<?php

  // Namespace
  namespace BMI\Plugin\Heart;

  // Allow this script to run only via CLI
  $cli = (php_sapi_name() === 'cli' || defined('STDIN')) ? true : false;
  if (!$cli) {
    echo '010011010101';
    exit;
  }

  // Get fields
  $file = __DIR__ . '/htaccess/bmi_cli_data.json';
  if (!file_exists($file)) {
    echo '010011010111';
    exit;
  }
  $fields = json_decode(file_get_contents($file));
  // @unlink($file);

  // Let other files know that it's CLI request
  define('BMI_CURL_REQUEST', false);
  define('BMI_CLI_REQUEST', true);

  // Load some constants
  define('ABSPATH', $fields->abs_dir);
  if (substr($fields->content_dir, -1) == '/') {
    $fields->content_dir = $fields->content_dir . '/';
  }
  define('WP_CONTENT_DIR', $fields->content_dir);
  define('BMI_CONFIG_DIR', $fields->config_dir);
  define('BMI_BACKUPS', $fields->backup_dir);
  define('BMI_ROOT_DIR', $fields->root_dir);
  define('BMI_INCLUDES', BMI_ROOT_DIR . 'includes');
  define('BMI_SAFELIMIT', intval($fields->safelimit));

  // Replace error-log file
  @ini_set('log_errors', 1);
  @ini_set('error_log', BMI_CONFIG_DIR . '/background-errors.log');

  // Increase max execution time
  @set_time_limit(259200);
  @ini_set('memory_limit', (BMI_SAFELIMIT * 4 + 16) . 'M');
  @ini_set('max_input_time', '259200');
  @ini_set('max_execution_time', '259200');
  @ini_set('session.gc_maxlifetime', '1200');

  // Let the server know it's server-side script
  if (function_exists('ignore_user_abort')) {
    @ignore_user_abort(true);
  }

  if (function_exists('session_write_close')) {
    @session_write_close();
  }

  // Catch anything if possible
  try {

    // Load bypasser
    require_once BMI_INCLUDES . '/bypasser.php';
    $request = new BMI_Backup_Heart(true,
      $fields->config_dir,
      $fields->content_dir,
      $fields->backup_dir,
      $fields->abs_dir,
      $fields->root_dir,
      $fields->url,
      [
        'identy' => $fields->identy,
        'manifest' => $fields->manifest,
        'safelimit' => $fields->safelimit,
        'rev' => $fields->rev,
        'backupname' => $fields->backupname,
        'start' => $fields->start,
        'filessofar' => $fields->filessofar,
        'total_files' => $fields->total_files,
        'browser' => 'cli'
      ],
      0,
      0,
      0
    );

    // Handle request
    $request->handle_batch();

  } catch (\Exception $e) {

    error_log('There was an error with Backup Migration plugin: ' . $e->getMessage());
    error_log(strval($e));

  } catch (\Throwable $e) {

    error_log('There was an error with Backup Migration plugin: ' . $e->getMessage());
    error_log(strval($e));

  }

  // End the server task
  exit;
