<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) {
    exit;
  }

  $bmiSupportForumUrl = "https://wordpress.org/support/plugin/backup-backup/";
  $bmiSupportEmail = "support" . "@" . "backupbliss" . "." . "com";
  $bmiSupportMessage = __('Now open a new thread in the %s1support forum%s2, and share there your debug code.', 'backup-backup');
  $bmiSupportMessage = str_replace('%s1', '<a href="' . $bmiSupportForumUrl . '" class="secondary hoverable" target="_blank">', $bmiSupportMessage);
  $bmiSupportMessage = str_replace('%s2', '</a>', $bmiSupportMessage);

  $bmiSupportMessage2 = __('Please email us the code to %s1, so that we can start investigating. Thank you!', 'backup-backup');
  $bmiSupportMessage2 = str_replace('%s1', '<a href="mailto:' . $bmiSupportEmail . '" class="secondary hoverable" target="_blank">' . $bmiSupportEmail . '</a>', $bmiSupportMessage2);

  $bmiSupportMessage3 = __('Please also provide some details like, my migration/backup failed at x%.', 'backup-backup');
  $bmiSupportMessage4 = __('Otherwise forum moderators may remove the topic.', 'backup-backup');
?>

<div class="modal modal-no-close" id="after-logs-sent-modal" data-error-source="manual">

  <div class="modal-wrapper no-hpad no-vpad" style="max-width: 900px; max-width: min(900px, 80vw)">
    <a href="#" class="modal-close">×</a>
    <div class="modal-content">

      <div class="mm60 f26 bold black center mbl mt lh28">
        <?php _e('We received the debug infos!'); ?><br>
      </div>

      <div class="mm60 mbll f18 medium">
        <?php _e('Your debug code:'); ?>
      </div>

      <div class="mm60 mbl">
        <div class="bmi-support-code-section relative">
          <span id="bmi-support-code-generated">BMI_PLACEHOLDER</span>
          <div class="mm60 right-align" style="position: absolute; top: 5px; right: -50px;">
            <a href="#" class="btn inline btn-with-img btn-img-low-pad btn-pad bmi-copper" data-copy="bmi-support-code-generated">
              <div class="text">
                <img src="<?php echo $this->get_asset('images', 'copy-icon.png'); ?>" alt="copy-img">
                <div class="f18 semibold"><?php _e('Copy', 'backup-backup') ?></div>
              </div>
            </a>
          </div>
        </div>
      </div>

      <?php if (!defined('BMI_BACKUP_PRO')): ?>
      <div class="mm60 f18 mbl">
        <?php echo $bmiSupportMessage; ?><br /><br />
        <?php echo $bmiSupportMessage3; ?><br />
        <?php echo $bmiSupportMessage4; ?>

        <div class="center mbll mtl">
          <a class="btn inline semibold mm60 f16" href="https://wordpress.org/support/plugin/backup-backup/" target="_blank">
            <?php _e('Go to Support Forum', 'backup-backup') ?>
          </a>
        </div>
        <div class="center f16 tooltip-html info-cursor" tooltip="<?php _e("Your account on Wordpress.org (where you open a new support thread) is different to the one you login to your WordPress dashboard (where you are now). If you don't have a WordPress.org account yet, please sign up at the top right on here. It only takes a minute :) Thank you!", 'backup-backup') ?>">
          <?php _e('Trouble logging in there?', 'backup-backup') ?>
        </div>
      </div>
      <?php else: ?>
      <div class="mm60 mb f18 lh28">
        <?php echo $bmiSupportMessage2; ?>
      </div>
      <?php endif; ?>

      <div class="mm60 f18 center mb">
        <a href="#" class="modal-closer text-muted" data-close="after-logs-sent-modal"><?php _e('Close window', 'backup-backup') ?></a>
      </div>

    </div>
  </div>

</div>
