# Spam protection, AntiSpam, FireWall by CleanTalk 

[![Build Status](https://travis-ci.org/CleanTalk/wordpress-antispam.svg?branch=master)](https://travis-ci.org/CleanTalk/wordpress-antispam)

**License: GPLv2**

Spam protection, antispam, all-in-one, premium plugin. No spam comments & users, no spam contact form & WooCommerce anti-spam.

##Description

**Supports: Contact Form 7, Ninja Forms, Gravity Forms, MailChimp, Formidable forms, WooCommerce, JetPack comments and contact form, BuddyPress, bbPress, Fast Secure Contact form, S2Member, MailPoet, ConvertKit, ActiveCampaign, any WordPress registrations & contact forms and themes. Just setup and forget the spam!** 

No CAPTCHA, no questions, no animal counting, no puzzles, no math and no spam bots. Universal AntiSpam plugin.

= AntiSpam features =
1. Stops spam comments.
1. Stops spam registrations.
1. Stops spam contact emails.
1. Stops spam orders.
1. Stops spam bookings.
1. Stops spam subscriptions.
1. Stops spam surveys, polls.
1. Stops spam in widgets.
1. Stops spam in WooCommerce.
1. Checks and removes the existing spam comments and spam users.
1. Compatible with mobile users and devices. 
1. Compatible with General Data Protection Regulation (GDPR) (EU). 

= Public reviews =
> Using CleanTalk on WPLift was a great test as we receive huge amounts of spam.
> *Oliver Dale, <a href="http://wplift.com/wordpress-anti-spam-plugin" target="_blank">WPLift.com</a>.*

>I know you have heard of a number of anti-spam plugins. But you must know, the cloud-based ones are the best regarding detection rate. They compare all the content in forms with their own algorithm to find out the legibility. 
>*<a href="https://www.techwibe.com/cleantalk-wordpress-plugin-review/" target="_blank">www.techwibe.com</a>*

> The key selling point of CleanTalk for me is not simply its effectiveness. It's the fact that CleanTalk works in the background. It does not make users jump through hoops in order to submit a comment or complete a form.
> <a href="https://www.kevinmuldoon.com/cleantalk-anti-spam-service/">www.kevinmuldoon.com</a>

= Free trial then $8 per year =
CleanTalk is a free anti spam plugin which work with the premium Cloud AntiSpam service cleantalk.org. This plugin as a service https://en.wikipedia.org/wiki/Software_as_a_service.

= AntiSpam protection for comments =
Native spam protection for WordPress, JetPack comments and any other comment plugins. The plugin moves spam comments to SPAM folder or you can set the option to ban spam comments silently. You can also enable the option in the plugin settings to auto-delete comments from SPAM folder.

= Spam bot registrations filter =
Filters spam bots on registration forms of WordPress, BuddyPress, bbPress, S2Member, WooCommerce, Profile builder, Login with AJAX and any other registration plugins.

= Protection from contact form spam =
The plugin is tested and ready to protect from spam emails via Formidable forms, Contact form 7, JetPack Contact form, Fast Secure Contact form, Ninja forms, Landing pages, Gravity forms, Contact Form by BestWebSoft, Simple Contact Form Plugin - PirateForms, Visual Form Builder, Form, Contact Form by WebDorado, Contact Form Email, MW WP Form, Contact Form by Jeff Bulllins, Easy Contact, Contact Us Form, Grunion Contact Form, WCP Contact Form, Easy WordPress Contact Form Plugin, WPForms Lite, Custom Contact, Forms, Amo Forms, Caldera Forms, Visual Form Builder, Contact Form Clean and Simple, Divi by Elegant Themes and any other themes or custom contact forms, amoForms, Custom Contact Form, Ultimate Form Builder, Contact Bank - Contact Forms Builder, Forms easily built with Smart Forms, Quick Contact Form, Usernoise contact form, cformsII - contact form, Contact Form by Web-Settler, HubSpot Marketing Free.

= WooCommerce spam filter =
Anti-spam by CleanTalk filters spam registrations and spam reviews for WooCommerce. The plugin is fully compatible with WooCommerce 2.1 and higher.

= Newsletters antispam filter =
Anti-spam by CleanTalk filters spam subscriptions for MailPoet, MailChimp, PopupAlly and many other newsletter plugins.

= Spam filter for theme contact forms =
The plugin blocks spam emails via any theme (built-in ones included) contact forms. The plugin filters spam emails silently (without any error notices on WordPress frontend) in AJAX forms as well.

= bbPress spam filter =
Spam protection for everything about bbPress: logins, registrations, forums, topics and replies.

= Other spam filters =
* WordPress Landing Pages.
* WP User Frontend, UserPro. 
* Any WordPress form (checkbox 'Custom contact forms').
* Any submission to the site (checkbox 'Check all POST data')

= Compatible with WordPress cache plugins =
* W3 Total Cache, Quick Cache, WP Fastest Cache, Hyper Cache, WP Super cache, WP-Rocket and any other cache plugins. 

= Check existing comments for spam. Bulk spam comments removal. Spam comment Cleaner =
With the help of anti-spam by CleanTalk you can inspect through existing comments to find and quickly delete spam comments at once. To use this function, go to WP Console -> Comments -> Find spam comments.

= Check existing users for spam. Bulk spam accounts removal. Spam users cleaner =
With the help of anti-spam by CleanTalk you can inspect through existing accounts to find and quickly delete spam users at once. For use this function, go to WP Console -> Users -> Check for spam. Also, you can export a list of spam users to the CSV.

= Blocking users by country = 
Automatically block comments and registrations from the countries you have set a ban for. This option is useful in cases of manual spam protection and for protection enhancement. If your site is not intended for international audience and you do not expect comments/users from other countries.

= Blocking comments by "stop words" =
You can block comments which contain "stop words" to enhance spam protection and messages with obscene words blocking. You can add particular words or phrases.

= Private black lists for anti-spam service =
Automatically block comments and registrations from your private black
IP/email address list. This option helps to strengthen the spam protection from a manual spam or block unwanted comments from users. You can add not only the certain IP addresses, but also a separate subnet to your personal black list.

= Private black list for Spam FireWall =
It allows you to add individual IP addresses and subnets to Spam FireWall. It
blocks the spam attacks from IP addresses which are not included in the SFW base yet. This option can help to block HTTP/HTTPS DDoS, SQL, brute force attacks and any others that made it through the HTTP/HTTPS. You can add not only the certain IP addresses, but also a separate subnet to your personal black list.

= Low false/positive rate =
This plugin uses multiple anti-spam tests to filter spam bots having as low false/positive rate as possible. Multiple anti-spam tests help to avoid false/positive blocks of the real website visitors even if one of the tests failed.

= How effective is CleanTalk? = 
Accurately blocking spam is not an easy thing to do, but CleanTalk has a very low proven False/Positive rate. Here is actual statistics on false positives for all customers.

* Registrations - 0.007%
* Comments - 0.001%
* Contact forms - 0.001%
* Orders (WooCommerce) - 0.008%

The statistic was calculated on November 10 2017 for 1 million requests.

= How CleanTalk improves SEO for your website? =
So, you already know that the speed of the site has a direct impact on SEO.

*CleanTalk works faster than most of the other anti-spam plugins.* It is common knowledge that the faster your site loads, the better your customer experience is, the better your SEO will be, and the better your site will convert. Speed is becoming increasingly important in SEO, conversion and user experience. Today, site speed is one of the most important ranking factors on Google. A site that loads slowly will lose visitors and potential revenue.

There are different ways of improving your site's loading performance. One important parameter for site performance is to install well-developed plugins from a reputable source.

Among anti-spam plugins CleanTalk AntiSpam is one of the fastest. Despite the
large plugin functionality, the developers have optimized the performance of
the plugin so that AntiSpam by CleanTalk is faster than most analogs. This contributes to the cloud service architecture, as all calculations take place in the cloud, not on the server, the server receives the finished result for further action.

https://s.w.org/plugins/cleantalk-spam-protect/screenshot-5.png?r=1288723

= How CleanTalk works? =
 * A visitor writes a comment or registers
 * Anti-Spam by CleanTalk plugin sends action parameters into the CleanTalk cloud
 * Service analyzes the parameters
 * If this is a visitor, the comment will be published. If it's a spam bot, then CleanTalk blocks this comment or registration.
 * Parameters are written to the spam log which can be viewed in the Control Panel service.

CleanTalk team has been developing a cloud antispam system for five years and has created a truly reliable anti-spam service designed for you to guarantee
your safety.

= Spam attacks log = 
Service CleanTalk (this plugin is a client application for CleanTalk anti-spam service) records all filtered comments, registration and other spam attacks in the "Log of spam attacks" and stores the data in the log for up to 45 days. Using the log, you can ensure reliable protection of your website from spam and no false/positive filtering.

= Spam FireWall =
CleanTalk has an advanced option "Spam FireWall". This option allows blocking the most active spam bots before they get access to your website. It prevents spam bots from loading website pages so your web server doesn't have to perform all scripts on these pages. Also it prevents scanning of pages of the website by spam bots. Therefore Spam FireWall significantly reduces the load on your web server. Spam FireWall also makes CleanTalk the two-step protection from spam bots. Spam FireWall is the first step and it blocks the most active spam bots.  CleanTalk Anti-Spam is the second step and checks all other requests on the website in the moment of submitting comments/registers etc. 

= How Spam FireWall works? = 
 * The visitor enters to your web site.
 * HTTP request data are being checked in the nearly 5.8 million of the identified spam bot IPs.
 * If it is an active spam bot, the bot gets a blank page, if it is a visitor then he receives a normal page. This process is completely transparent for the visitors. 

All the CleanTalk Spam FireWall activity is being logged in the process of filtering.

= Spam FireWall DDoS Protection =
Spam FireWall can mitigate HTTP/HTTPS DDoS attacks. When an intruder makes GET requests to attack your website, Spam FireWall blocks all requests from bad IP addresses. Your website gives the intruder a special page with the description of DDoS rejection instead of the website pages. Therefore Spam FireWall helps to reduce CPU usage of your server.
[youtube https://www.youtube.com/watch?v=Eu5Zqryvj4k]

= XML-RPC brute force protection = 
Spam FireWall can mitigate XML-RPC brute force attacks. It blocks XML-RPC attacks from bad IP addresses. This helps to prevent bruteforce attacks by a Remote Procedure Call.

= No spam comments, no spam registrations, no spam contact emails, no spam trackbacks. CAPTCHA-free anti-spam for WordPress =
Spam is one of the most irritating things. Spam rates are increasing every year and conventional anti-spam can no longer handle all spam bots. CleanTalk prevents and automatically blocks spam. You'll be surprised how effective CleanTalk is in protecting from spam. 

= AntiSpam plugin info = 
CleanTalk is an all-in-one antispam solution for WordPress that protects login, comment, contact and WooCommerce forms at once. You don't need to install separate antispam plugins for each form. It allows your blog to work faster and save resources. After installation you will forget about spam; your CleanTalk plugin will do all the work. You won't have to deal with spam as CleanTalk does this for you automatically.  

CleanTalk is a transparent antispam tool, we provide detailed stats of all incoming comments and logins. You can always be sure that **there are no errors**. We have developed a mobile app for you to see antispam stats wherever you want.

We have developed the antispam for WordPress that protects you from spam bots at the maximum level allowing you to provide your visitors a simple and convenient form of comments/registrations without annoying CAPTCHAs and puzzles. CleanTalk detects spam in multistage tests allowing us to block up to 99.998% of spam bots. 
The anti-spam method offered by CleanTalk avoids inconvenient for communication methods (CAPTCHA, question-answer etc.), and offers to your site visitors a more comfortable one. 

CleanTalk is a premium anti-spam service for WordPress, the plugin works with
our own CleanTalk Cloud Service. Anti Spam by CleanTalk offers a free trial, you can look at the <a href="https://cleantalk.org/price">pricing</a> here. We provide anti-spam services at the highest level. To maintain this level we cannot afford to offer a free version of our service, as this will immediately affect the quality of the providing anti-spam protection. Paying for a year of anti-spam service, you save a lot more and receive: 
 
 * Up to 99.998% protection from spam bots.
 * Time and resources saving.
 * More registrations/comments/visitors.
 * Spam protection of the several websites at once in different CMS.
 * Ease in installation and using.
 * Traffic increase and loyalty to the users.
 * 24/7 technical support.
 * Clear stats.
 * No captcha (reCaptcha), puzzles, etc.
 * Free mobile app to control anti-spam protection on your website.

= Additional features =
* Daily and weekly detailed anti-spam reports: traffic VS spam. 
* Apps for iPhone, Android to control anti-spam service, comments, signups, contacts, traffic and spam stats for the last 7 days.
* AntiSpam apps for most popular CMS on cleantalk.org. 

= How to protect sites from spam bots without CAPTCHA? =
The most popular anti spam method is CAPTCHA - the annoying picture with curved and sloping symbols, which are presented to the visitor to decipher and fill in. In is supposed that spam bots won't discern these CAPTCHA, but a visitor will. CAPTCHA provokes great irritation, but if the visitor wants to comment, he has to fill in these symbols time after time, making mistakes and starting once again. Sometimes CAPTCHA reminds us of the doodles of a two year old child. For users with vision problems CAPTCHA is an insurmountable obstacle. Users hate captcha. Captcha for users means "hate". Unreadable CAPTCHA stops about 80% of site visitors. After 2 failed attempts to decipher CAPTCHA 95% of visitors reject further attempts. At the sight of CAPTCHA and after input errors, many visitors leave the resource. Thus, CAPTCHA helps to protect the resource spam both from bots and visitors. CAPTCHA is not a panacea from spam. Doubts concerning the Need for CAPTCHA?

*"Ultimately, CAPTCHAs are useless for spam because they're designed to tell you if someone is 'human' or not, but not whether something is spam or not." Matt Mullenweg*

You do not have to work in IT to know what spam is. Besides piles of unwanted email, there are spam bots, or special software programs designed to act as human website visitors that post unwelcome messages over the Internet to advertise dubious services. More often than not spam messages do not even make sense. Similar to bacteria and virus mutations developing antibiotic resistance, spam bots are becoming more resilient in penetrating Internet firewalls and security layers. 

= CleanTalk's features =
Anti-Spam by CleanTalk is one of the fastest plugins that allows you to lower the server load. One of the important parameters for each webmaster is the speed of the site, so we make sure that our plugin consumes as few server resources as possible. The Cloud Service provides the advantage: all data processing takes place in the Cloud. 

CleanTalk team has developed unique anti spam algorithms to assess visitors behavior. CleanTalk analyzes user behavior and the parameters of the filled forms. Our anti-spam module, being installed in your website, sends the behavior parameters of either a visitor or a spam bot. When these parameters are estimated, the anti spam service makes a decision - to post a message or to define it as spam and reject it. Based on these checks, the service forms its own list of email addresses used by spam bots.

The registrations of visitors are being checked in a similar manner. The service adds to the blacklist not just email addresses, but also IP addresses and domains of websites that promote themselves through spam mailing. All of this happens automatically and requires no action from the administration of the website. In 2.5 million queries the service makes a mistake in 40-45 cases, i.e. CleanTalk detects spam with 99.9982% accuracy. We constantly monitor these errors and make adjustments to our algorithms. Even with this exceptional accuracy our team is aiming to improve the figures over time. 

All-in-one. CleanTalk protects form spam all forms instantaneously - comments, registrations, feedback, contacts. No need to install additional plugins for each form. You save resources and increase performance of your website.

Spam attacks log. Anti-Spam by CleanTalk records all filtered comments, registrations and other spam attacks in the "Log of spam attacks" and stores the data in the log for up to 45 days. Using the log, you can ensure reliable protection of your website from spam and experience no false/positive filtering. 

With the help of anti-spam by CleanTalk you can check existing comments and users, to find and quickly delete spam comments at once. This allows administrators of websites to automatically check and identify spam bots, comments and users, which were not detected by conventional anti-spam tools. The existing comments and users checking process is performed in a database of the nearly 2 million identified spam bots. Detailed spam stats allows CleanTalk customers to fully control it. 

CleanTalk has an advanced option "Spam FireWall". This option allows you to block the most active spam bots before they get access to your website. It unloads you website pages when an attempt attack was made, so your web server won't run unnecessary scripts on these pages. Also it prevents any scanning of website pages by spam bots. Subsequently Spam FireWall significantly reduces your webserver load. Spam FireWall can mitigate HTTP/HTTPS DDoS attacks. When an intruder makes GET requests to attack your website, Spam FireWall will block requests from bad IP addresses. Your website gives the intruder a special page with a description of DDoS rejection instead of the website pages. Spam FireWall can help to reduce the CPU usage of your server because of this reason. 

"CleanTalk team has been developing a cloud spam protection system for five years and has created a truly reliable anti-spam service designed for you to guarantee your safety".

= Auto-Update CleanTalk AntiSpam =

CleanTalk Dashboard allows you to set auto-update plugin and select several websites and update the plugin at once on all sites by one click or you can setup auto-update for all websites or separate websites. 

Note: there is 24 hours delay before auto-update will do. This delay allows needing to avoid any issues. All updates that made through CleanTalk Dashboard manually will do immediately. 

Auto-updating system will work from CleanTalk AntiSpam version 5.88

= Translations = 
* Albanian (sq_AL) - thanks to fjalaime https://wordpress.org/support/users/fjalaime/ 
* French (fr_FR) - thanks to Gilles Santacreu http://net-ik.net
* Spanish (es_ES) - thanks to Andrew Kurtis and WebHostingHub

= Requirements =
WordPress 3.0 at least. PHP 5 with CURL or file_get_contents() function and enabled 'allow_url_fopen' setting. The plugin is fully compatible with PHP 7.

> Max power, all-in-one, premium anti-spam WordPress plugin. No comments & registrations spam, no contact spam, protects any forms. Just install and forget spam. 

== Installation ==

= Installation instructions =

1. Download, install and activate 'Anti-spam by CleanTalk'. 

2. Get Access key <a href="https://cleantalk.org/register?platform=wordpress" target="_blank">https://cleantalk.org/register</a>

3. Enter Access key in the settings: WordPress console -> Settings -> Antispam by CleanTalk

4. Do dummy spam comment (registration or contact message) with email **stop_email@example.com**. You should see notice: **Forbidden. Sender blacklisted.**

5. Done! The plugin is ready to use.

= Video guide - Anti-Spam Plugin Installation in WordPress. =

[youtube https://www.youtube.com/watch?v=SktF0s-go6A ]

**Important!** To test spam protection you must post a dummy submissions as website visitor (use must logged out from WordPress console), because the plugin doesn't filter submissions from WordPress administrators.

= How can setup plugin in WPMU version? =
In WordPress multisite version you can switch the plugin to use Global Access key. In this way the plugin doesn't show any options to enter Access key in plugin settings and doesn't show Trial banner in WordPress backend. To setup global CleanTalk access key for all websites in WPMU, define constant in your wp-config.php file before defining database constants:

```php
define('CLEANTALK_ACCESS_KEY', 'place your key here');
```

Now, all subsites will have this access key.

= Manage and control spam protection =

Go to <a href="https://cleantalk.org/my" target="_blank">Dashboard</a> at the cleantalk.org or use <a href="https://play.google.com/store/apps/details?id=org.cleantalk.app">Android</a>, <a href="https://itunes.apple.com/us/app/cleantalk/id825479913?mt=8">iPhone</a> anti-spam app to manage and control spam protection. 


== Frequently Asked Questions ==

= Why are they spamming me? =
Spammers want to get backlinks from your site to improve their site's PageRank or redirect your visitors to malicious sites.This level of spam can damage your reputation with readers and commentators if you fail to tackle it. It is not uncommon for some WordPress websites to receive hundreds or even thousands of comments every week. However, by using a CleanTalk plugin, spam can be easily handled by your WordPress website.

= Is the anti-spam protection safe for mobile visitors? =
Yes, it is. The plugin doesn't block mobile visitors as well as desktop website visitors. It uses several independent anti-spam tests to decrease the number of false outcomes and to have as low false-positive rate as possible. Multiple anti-spam tests help to avoid false/positive blocks for real website visitors even if one of the tests failed.

= What does the plugin do with spam comments? =
Spam comments are being moved to SPAM folder by default or you can set the option to ban spam comments silently.

= How can I test the anti-spam protection? =
Please use the email **stop_email@example.com** for comments, contacts or signups to see how the anti-spam protection works. Also you can see the logs for the last 7 days at the <a href="http://cleantalk.org/my/show_requests">Control panel</a> or look at the folder "Spam" for banned comments.

= Is the plugin effective against spam bots? =
The plugin Anti-Spam by CleanTalk stops up to 99.998% of spam comments, spam signups (registrations), spam contact emails, spam subscriptions, spam bookings or spam orders.

= Does the plugin protect from brute force, DoS attacks and spam attacks? =
Yes, it does. Please turn the option 'Spam FireWall' on in the plugin settings to protect your website from DoS/DDoS, XML-RPC attacks.

= How does the plugin stop spam? =
Please, note - administrator's actions are NOT being checked.

The plugin uses several simple tests to stop spammers:

1. **JavaScript anti-spam test.** 99% of spam bots don't have full JavaScript functions support. So, the plugin has the code which can be run by normal visitor and can't be run by the spam bot.
1. **Email, IP, domain spam activity list entries check.** The plugin uses spam activity database online at cleantalk.org, consisting of more than 20 billion spam activity records of IPs, Emails, Domains and ASN. If the sender's IP or Email is in the database, the sender gets some spam scores. To reduce false/positive rate the plugin not only uses the blacklist test to ban spammers, the sender will be banned when and only when multiple spam tests have been failed.
1. **Comment submit time.** Spam bots usually submit the info immediately after the page has been loaded, this happens because spam bots don't actually fill the web form, they just send $_POST data to the blog. The normal visitor sends the data after several seconds or minutes.

= Will the anti-spam plugin protect my theme? =
Yes, it will. The Anti-spam by CleanTalk is compatible with any WordPress theme.

= What about pingback, trackback spam? = 
The plugin passes pingbacks without any checks by default. All trackbacks will be blocked if the sender had spam activity.

= Can I use CleanTalk with Akismet? =
Sure, you can use CleanTalk with Akismet. In this case you will probably have higher false/positive rate (when legitimate comments/signups are being denied), but you will have stronger anti-spam protection on your website.

= Is CleanTalk better than Akismet? =
Please look at this features comparison here https://cleantalk.org/cleantalk-vs-akismet

= Can I use CleanTalk to remove pending spam comments? =
Yes, you can. The plugin has the option to test all pending comments via database of <a href="https://cleantalk.org/blacklists">spam active IP/Email</a>, found spam comments will be moved to Trash folder.

= How does the plugin find spam in pending comments or registered accounts? =
The plugin checks all non-spam comments in the blacklist database and shows you those senders who have spam activity on other websites.	
There are some differences between blacklist database and API to protect you from spam bot registrations/comments online. Blacklists show all history of spam activity, but our API (which is used in spam tests) relies on other parameters too: last day of activity, number of spam attacks during the last days etc. These mechanisms help us to reduce the number of false outcomes. So, there is nothing strange, if some emails/IPs are not found by bulk comments/accounts test.

To check comments please go here:
> WordPress console -> Comments -> Find spam comments

To check users please go here:
> WordPress console -> Users -> Find spam users 

= Should I use other anti-spam tools (Captcha, reCaptcha and etc.)? =
CleanTalk stops up to 99.998% of spam bots, so you can disable other anti-spam plugins (especially CAPTCHA-type anti-spam plugins). In some cases several anti-spam plugins could conflict with each other, so it would be better to use just one plugin.  

= Is the plugin compatible with WordPress MultiUser (WPMU or WordPress network)? =
Yes, the plugin is compatible with WordPress MultiUser. Each blog in multisite environment has individual anti-spam options for the protection from spam bots.

= After the installation I noticed that the number of spam attacks has been increased in the stats =
There are a few reasons for this:

* With the indexing of your web-site by the search systems, appearance of external links and better search results position, your web-site attracts more and more spambots.
* Non-transparent protection systems like CAPTCHA or question/answer, that don't have spam attacks stats, don't let you see the whole picture, or the picture is incomplete.
* Counting methods for spam attacks and spam bots are different for different systems, thus the diversity appears. We seek to provide detailed stats.

= Why my dummy "spam" comment passed to the WordPress? =
The plugin has several options to detect spam bots and humans. If you just post spammy text like this:

    "I want to sell something", "Buy something here.." and etc

the comments will be passed, because the plugin detects sender as a human. So, use special email *stop_email@example.com* to test the anti-spam functionality or wait a few days to see how the plugin works. 

= Is it free or paid? =
The plugin is free. But the plugin uses CleanTalk cloud service to filter spam bots. You have to register an account and then you will receive a free trial to test anti-spam for comments, registrations, bookings, contacts or orders. When the trial (on CleanTalk account) is finished, you can renew the subscription for 1 year or deactivate anti-spam plugin.

= Can I use CleanTalk with cache plugins? =
Anti-spam by CleanTalk doesn't use static HTML code in its templates, so all anti-spam functions work correctly with any WordPress cache plugins.

= Does the plugin protect from spam bots if I use forms with third-party services? =
Yes, it does. Plugin protects web-forms on your websites which send data to third-party servers (like MailChimp). To enable this protection set the option 'Protect external forms' in the plugin settings. 

= Does CleanTalk compatible with Cloudflare? = 
CleanTalk is fully compatible with CloudFlare. Service doesn't filter CloudFlares IP's (AS13335) through blacklists database, so in this case plugin/service filters spam bots using other anti-spam tests. 

= Is CleanTalk compatible with a content delivery network (CDN)? = 
Yes, it is. CleanTalk works with any CDN system, i.e. CloudFlare, MaxCDN, Akamai.  

= Can I use CleanTalk functionality in my plugins? =
Yes, you can. Just use following snippet:

```php
<?php 

if( ! function_exists('ct_test_message') ) {
    include_once( ABSPATH . '/wp-content/plugins/cleantalk-spam-protect/cleantalk.php' );
}	

//for registration test:
$res = ct_test_registration("nickname", "stop_email@example.com", "127.0.0.1");

//or for some other messages (contact forms, comments etc.)
$res = ct_test_message("nickname", "stop_email@example.com", "127.0.0.1", "test message");
```

$res now contents array with two parameters:
  * $res['allow'] - is request allowed (1) or not (0)
  * $res['comment'] - comment for our server's decision.

= I see two loads of script cleantalk_nocache.js. Why do you use it twice? =
This script is used for AJAX JavaScript checking. Different themes use different mechanisms of loading, so we use two methods for loading our script. If you absolutely know what you are doing, you can switch one of the methods off by defining constants in your wp-config.php file:

```php
define('CLEANTALK_AJAX_USE_BUFFER', false); //false - don't use output buffering to include AJAX script, true - use it
```

or

```php
define('CLEANTALK_AJAX_USE_FOOTER_HEADER', false); //false - don't use wp_footer() and wp_header() for including AJAX script, true - use it
```

= Can I add exclusions for some pages of my site? =
Yes, you can. Add this string in your wp-config.php file before defining database constants:

```php
$cleantalk_url_exclusions = array('url1', 'url2', 'url3');
```

Now, all pages containing strings 'url1', 'url2', or 'url3' will be excluded from anti-spam checking. Remember, that this option will not be applied in registration and comment checking - they are always protected from spam. This is similar to regular expression /.*url1.*/ or wildcard like *url1*.

For example: If you need to except these URLs:
example.com/some/thing
example.com/some/one
example.com/some/body
You should type this in wp-config.php:

```php
$cleantalk_url_exclusions = array('some');
```

= Can I add exclusions for some IP addresses? =
Yes, you can. Add this string in your wp-config.php file before defining database constants:

```php
$cleantalk_ip_exclusions = array('127.0.0.1', '8.8.8.8');
```

Now, all requests from IP 127.0.0.1 and 8.8.8.8 will be excluded from anti-spam checking. Remember, that this option will not be applied in registration and comment checking - they are always protected from spam.

= Can I not send my personal data to CleanTalk servers? =
Yes, you can exclude your data. Add this string in your wp-config.php file before defining database constants:

```php
$cleantalk_key_exclusions = array('key1', 'key2', 'key3'); 
```

Now all fields in your submissions with the keys named 'key1', 'key2' or 'key3' will be excluded from spam checking.

= How to test Spam FireWall? =
Use special IP 10.10.10.10 in URL to test Spam FireWall. For example,

```
https://cleantalk.org/blog/?sfw_test_ip=10.10.10.10
```

= How can I enter access key in WPMU version? =
To set up global CleanTalk access key for all websites in WPMU, define constant in your wp-config.php file before defining database constants:

```php
define('CLEANTALK_ACCESS_KEY', 'place your key here');
```

Now, all subsites will have this access key.

= Why is CleanTalk faster and more reliable than stand-alone solutions? =
All anti-spam checks are held in the cloud and don't overload the web server. The cloud solutions have a huge advantage since the parameters are being compared with information from more than 100,000 websites.

= I see a lot of blocked messages with the reason "Forbidden. Please enable JavaScript. Spam sender name." in my logs =
A lot of spam bots can't perform JavaScript code, so it is one of the important checks and most of the spam bots will be blocked with the reason **"Forbidden. Please enable JavaScript. Spam sender name."** All browsers can perform JS code, so real visitors won't be blocked.

If you or some of your visitors have the error **"Forbidden. Enable JavaScript."** please check JavaScript support in your browser and do this JavaScript test at this page: https://cleantalk.org/checkout-javascript-support.

If you think that there is something wrong in the messages blocking, let us know about it. Please submit a support request here: https://cleantalk.org/my/support.

= Does the plugin work with Varnish? =
CleanTalk works with Varnish, it protects WordPress against spam, but by default the plugin generates a few cookies for the protection from spam bots and it also disables Varnish cache on pages where CleanTalk's cookies have been stored. To get rid of the issue with cache turn off the option 'Set cookies' in the plugin settings.

```
WordPress console -> Settings -> CleanTalk -> Advanced settings
```

Now the plugin will protect WordPress comments, registrations and most of popular contact forms, but will not protect some of rarely used contact forms. 

= Does the anti-spam plugin work with Accelerated Mobile Pages (AMP)? =
Yes, it does. But you have to turn off the option 'Use AJAX for JavaScript check' in Advanced settigns of the plugin to be fully compatible with Accelerated Mobile Pages. 

= How to close renewal or trial notice in the WordPress backend? =
To close the notice please save the plugin settings again or it will be closed automatically within 60 minutes after the renewal. 

= I'm using PHP 4.2 version and i'm getting errors related with JSON. Why does it happens? =
СleanTalk is no longer supports PHP lower than 5.2 version because the support code have incompatibility with PHP 7 version. Please, upgrade your PHP. If you couldn't perform that, let us know about it via support ticket here: https://cleantalk.org/my/support.

= Should I change anything in the plugin's settings or in my CleanTalk Control Panel when I switch my website from HTTP to HTTPS or vice versa? =
No. You don't need to change anything in the plugin's settings or in your CleanTalk Control Panel. The plugin will work regardless of the protocol.

= How to use Anti-Spam Log? =
The following possibilities are available for you in the Anti-Spam Log:

- Time period for all spam records you want to see.

- Filter spam records by their status: Any status, Denied, Approved.

- Filter spam records by your websites.

- Filter spam records by country they came from.

- Filter spam records by IP address, e-mail address or username.

- Available options for a specific record:

  * Details - see item 4 below.
  * Spam/Not Spam - press this string if our system made wrong decision and blocked or approved a registration, a comment ot a contact form submission. More about it here: https://cleantalk.org/faq#feedback_spam
  * Delete - delete a record permanently.
  * Personal blacklists - go to your website Black&White Lists page.
  * Record details: block reason, body of the message, additional caught data.

= Spam FireWall and AntiSpam - Networks Blocking = 

Anti-Spam - will blocks users from selected IP or network from using contacts/messages/registrations/comments forms.
Spam FireWall - will blocks users from selected IP or network from entering the website.

Please, read more here 
https://cleantalk.org/help/sfw-blocks-networks


= Spam Comment Management =

By default, all spam comments are placed in the spam folder, now you can change the way the plugin deals with spam comments:

1. **Move to the Spam folder.** All spam comments will be placed to the folder "Spam" in the WordPress Comments section except comments with Stop-Words. Stop-Word comments will be always stored in the "Pending" folder.

You can prevent the proliferation of Spam folder. It can be cleaned automatically using the option "Keep spam comments for 15 days." Enable this option in the settings of the plugin: WordPress Admin Page -> Settings -> Antispam by CleanTalk -> Advanced settings -> enable "Keep spam comments for 15 days" -> Save Changes.

2. **Move to Trash.** All spam comments will be placed to the folder "Trash" in the WordPress Comments section except comments with Stop-Words. Stop-Word comments will be always stored in the "Pending" folder.

3. **Ban comments without moving to WordPress backend.** All spam comments will be deleted permanently without going to the WordPress backend except comments with Stop-Words. Stop-Word comments will be always stored in the "Pending" folder.

What comments were blocked and banned can be seen in the Anti-Spam Log here: https://cleantalk.org/my/show_requests?int=week

To manage the actions with spam comments, go to the Control Panel, select the website you want to change the actions for and go to "Settings" under the name of the website.

Please, read more here:
https://cleantalk.org/help/spam-comment-management

= How do I report a missed spam bot or incorrect filter? =

If you think the service has missed a spam bot or improperly filtered visitor to the website, you may notify us via the Anti-spam control panel. To do this,
Log in to Control panel https://cleantalk.org/my.
Click the line "Log" under the name of your website.
When you mark a record as "SPAM", its e-mail and IP-address will be added to your personal blacklist for your website.
When you mark a record as "Not SPAM", its e-mail and IP-address will be added to your personal white list for your website.

Please, read more here
https://cleantalk.org/faq#feedback_spam

= Is the plugin fast? =
We develop plugin to do it as optimized as possible, CleanTalk doesn't downgrade response time in backend or frontend. The plugin proccess only POST requests to WordPress core, it tackes less than 1 second to return results.

= Is the plugin EU GDPR compatible? =
Yes, it is. Please read this article,
<a href="https://cleantalk.org/help/CleanTalk-GDPR-Compliance">https://cleantalk.org/help/CleanTalk-GDPR-Compliance</a>