<?php
 
 if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
 class webdWoocommerceReportingStatisticsAdmin{

	public $allowed_html = array(
            'a' => array(
                'style' => array(),
                'href' => array(),
                'title' => array(),
                'class' => array(),
                'id'=>array(),
				'target'=>array(),
            ),
			'i' => array('style' => array(),'class' => array(),'id'=>array() ),
            'br' => array('style' => array(),'class' => array(),'id'=>array() ),
            'em' => array('style' => array(),'class' => array(),'id'=>array() ),
            'strong' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h1' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h2' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h3' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h4' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h5' => array('style' => array(),'class' => array(),'id'=>array() ),
            'h6' => array('style' => array(),'class' => array(),'id'=>array() ),
            'img' => array('style' => array(),'class' => array(),'id'=>array() ),
            'p' => array('style' => array(),'class' => array(),'id'=>array() ),
            'div' => array('style' => array(),'class' => array(),'id'=>array() ),
            'section' => array('style' => array(),'class' => array(),'id'=>array() ), 
            'ul' => array('style' => array(),'class' => array(),'id'=>array() ),
            'li' => array('style' => array(),'class' => array(),'id'=>array() ),
            'ol' => array('style' => array(),'class' => array(),'id'=>array() ),
            'video' => array('style' => array(),'class' => array(),'id'=>array() ),
            'blockquote' => array('style' => array(),'class' => array(),'id'=>array() ),
            'figure' => array('style' => array(),'class' => array(),'id'=>array() ),
            'figcaption' => array('style' => array(),'class' => array(),'id'=>array() ),
            'style' => array(),
            'button' => array(
                'class' => array(),            
            ),

            'input' => array(
                'type' => array(), 
				'class' => array(), 				
				'placeholder' => array(), 
				'disabled' => array(),		
            ),				
            'option' => array(
                'value' => array(),
                'stock' => array(),
                'quantity' => array(),
                'price' => array(),
                'id' => array(),              
            ),			
            'iframe' => array(
                'height' => array(),
                'src' => array(),
                'width' => array(),
                'allowfullscreen' => array(),
                'style' => array(),
                'class' => array(),
                'id'=>array()                
            ),             
            'img' => array(
                'alt' => array(),
                'src' => array(),
                'title' => array(),
                'style' => array(),
                'class' => array(),
				'width' => array(),
				'height' => array(),
                'id'=>array()
            ), 
            'video' => array(
                'width' => array(),
                'height' => array(),
                'controls'=>array(),
                'class' => array(),
                'id'=>array()
            ),  
            'source' => array(
                'src' => array(),
                'type' => array(),
                'class' => array(),
                'id'=>array()
            ),             
        );


	
	public function proModal(){ ?>
		<div id="webdWoocommerceReportingStatisticsModal">
		  <!-- Modal content -->
		  <div class="modal-content">
			<div class='clearfix'><span class="close">&times;</span></div>
			<div class='clearfix verticalAlign'>
				<div class='columns2'>
					<center>
						<img style='width:90%' src='<?php echo plugins_url( 'images/'.$this->slug.'-pro.png', __FILE__ ); ?>' style='width:100%' />
					</center>
				</div>
				
				<div class='columns2'>
					<h3><?php  esc_html_e('Go PRO and get more important features!',$this->plugin);?></h3>
					
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Reporting & Stats with Product Search',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Reporting  & Stats with Category Search',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Next Months Forecast per Category',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Next Months Forecast per Product',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Custom Set From - To date to Search',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Get Reports by selecting Month',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Get Reports by selecting Year',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Export Feature in Excel',$this->plugin);?></p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Search functionality in Tables',$this->plugin);?></p>					
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Current Selling Products Low Stock Products Reminder!',$this->plugin);?> </p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Low Stock Products Report',$this->plugin);?> </p>
					<p><i class='fa fa-check'></i> <?php  esc_html_e('Email Report on Weekly or Monthly',$this->plugin);?></p>
					<p class='bottomToUp'><center><a target='_blank' class='proUrl' href='<?php print $this->proUrl; ?>'><?php  esc_html_e('GET IT HERE',$this->plugin);?></a></center></p>
				</div>
			</div>
		  </div>
		</div>		
		<?php
	}
	
	public function adminHeader(){
		?>
		<img src='<?php echo plugins_url( 'images/'.$this->slug.'.png', __FILE__ ); ?>' style='width:100%' />	
		<?php	
	}
	
	
	public function adminSettings(){
		        global $product;
				
				$this->tab = array( 'all' => __('GENERAL',$this->plugin),'years' => esc_html__('PER YEAR',$this->plugin),'months' => esc_html__('PER MONTH',$this->plugin),'top' => esc_html__('TOP 5 PRODUCTS',$this->plugin));
				if(isset($_GET['tab']) || (isset($_GET['tab']) && $_GET['tab']=='all' ) ){
					$this->activeTab = $_GET['tab'] ;
				}else $this->activeTab = 'all';
				echo '<h3 class="nav-tab-wrapper" >';
				foreach( $this->tab as $tab => $name ){
					$class = ( $tab == $this->activeTab ) ? ' nav-tab-active' : '';
					echo "<a class='nav-tab".$class." contant' href='?page=".$this->slug."&tab=".$tab."'>".$name."</a>";
				}
				?>
				<a class='nav-tab  proVersion' href="#" style='background:#42b72a;color:#fff' ><?php  esc_html_e('GO PRO',$this->plugin);?></a>
				<a class='nav-tab  extendwp_extensions' href="#" style='background:#9B2E91;color:#fff' ><i class='fa fa-plug'></i> <?php  esc_html_e('More extensions',$this->plugin);?></a>
				<?php
				echo "</h3>";
				
				?>
					
				<?php
				if(isset( $_GET['tab'] ) && $_GET['tab'] =='all'  ){?>
							<div class='report_widge'>
								<?php $this->select_dropdown(); ?>								
								<?php  $this->all_sales(); ?>
							</div>
				<?php }elseif( isset($_GET['tab']) && ( $_GET['tab'] =='years' || $_GET['tab'] =='months' ) ){?>
							<div class='report_widgt'>
								<?php $this->getOrdersBy(); ?>
							</div>				
				
				<?php }elseif(isset($_GET['tab']) && $_GET['tab'] =='stock'){?>
				<div class='premium_msg'>
				<p>
					<strong>
					<?php  _e('Only available on PRO Version',$this->plugin);?> <a class='premium_button' target='_blank'  href='<?php print $this->proUrl;?>'><?php  _e('Get it Here',$this->plugin);?></a>
					</strong>
				</p>
				</div>			
				<div class='report_widgt'>
								
					<div id="tabs3" class='clearfix'>
						<ul>
							<li><a href="#selling"><?php  esc_html_e('Selling Products Low Stock Reminder',$this->plugin);?></a></li>
							<li><a href="#noselling"><?php  esc_html_e('All Time Low Stock Products',$this->plugin);?></a></li>																		
						</ul>
						<?php $this->sellingProdStock(); ?>
						<?php $this->LowStock(); ?>
					</div>												
				</div>				
				<?php }elseif(isset($_GET['tab']) && $_GET['tab'] =='top'){?>
						<div class='report_widge'>
							<?php  $this->topSellers(); ?> 
						</div>				
				<?php }elseif(isset($_GET['tab']) && $_GET['tab'] =='email'){?>
				<div class='premium_msg'>
				<p>
					<strong>
					<?php  esc_html_e('Only available on PRO Version',$this->plugin);?> <a class='premium_button' target='_blank'  href='<?php print $this->proUrl;?>'><?php  esc_html_e('Get it Here',$this->plugin);?></a>
					</strong>
				</p>
				</div>				
					<form method="post" id='<?php print $this->plugin; ?>Form'  
					action= "<?php echo admin_url( "admin.php?page=".$this->slug."&tab=email" ); ?>">
					<?php
						settings_fields( $this->plugin."general-options" );
						do_settings_sections( $this->plugin."general-options" );				
						
					?></form>

						
				<?php }else{?>
							<div class='report_widge'>
								<?php $this->select_dropdown(); ?>								
								<?php  $this->all_sales(); ?>
							</div>					
				<?php }
	}
	
	public function adminFooter(){ ?>
		<div class='clearfix'>
		<hr>
		<div></div>
		<?php $this->rating(); ?>
		<a target='_blank' class='web_logo' href='https://extend-wp.com/wordpress-premium-plugins/'>
			<img  src='<?php echo plugins_url( 'images/extendwp.png', __FILE__ ); ?>' alt='Get more plugins by extend-wp.com' title='Get more plugins by extend-wp.com' />
		</a><div class='get_ajax'></div>
		</div>
		<?php 
	}

	public function rating(){
	?>
		<div class="notices notice-success rating is-dismissible">

			<?php esc_html_e( "You like this plugin? ", 'smw' ); ?><i class='fa fa-smile-o' ></i> <?php esc_html_e( "Then please give us ", $this->plugin ); ?>
				<a target='_blank' href='https://wordpress.org/support/plugin/webd-woocommerce-advanced-reporting-statistics/reviews/#new-post'>
					<i class='fa fa-star' ></i><i class='fa fa-star' ></i><i class='fa fa-star' ></i><i class='fa fa-star' ></i><i class='fa fa-star' ></i>
				</a>

		</div> 	
	<?php	
	}
	
	public function sendReport(){
		?>
		<select class='proVersion' >
			<option   readonly value=''><?php  esc_html_e('Select...',$this->plugin);?></option>
			<option value='yes'><?php  esc_html_e('yes',$this->plugin);?></option>
			<option value='no'><?php  esc_html_e('no',$this->plugin);?></option>
		</select>
		<?php
	}
	
	public function emailForReport(){
		?>
		<input type="text" readonly placeholder='Email to send - PRO Version' class='proVersion' />
		<?php
	}
	
	public function emailFrequency(){
		?>			
		<select  readonly class='proVersion' >
			<option   value=''><?php  esc_html_e('Select...',$this->plugin);?></option>
			<option value='daily'><?php  esc_html_e('Daily',$this->plugin);?></option>
			<option value='weekly'><?php  esc_html_e('Weekly',$this->plugin);?></option>
			<option value='monthly'><?php  esc_html_e('Monthly',$this->plugin);?></option>
		</select>			
		<?php
	}
	
	public function settingsSection(){
		add_settings_section($this->plugin."general", "", null, $this->plugin."general-options");
		add_settings_field('sendReport',"Send Report", array($this, 'sendReport'),  $this->plugin."general-options", $this->plugin."general");
		add_settings_field('emailFrequency',"Email Frequency", array($this, 'emailFrequency'),  $this->plugin."general-options", $this->plugin."general");
		add_settings_field('emailForReport',"Emai for Report", array($this, 'emailForReport'),  $this->plugin."general-options", $this->plugin."general");			
	}


	public function total_sales() {
		 
		// Get orders processing and on-hold.
		$args = array(
			'status' => array('wc-completed','wc-processing', 'wc-refunded'),
		);
		$orders = wc_get_orders( $args );
		$total = array();
		foreach ( $orders as $order ) {
			
			array_push( $total, $order->get_total() ); 
		}
		return array_sum( $total );
	}
	
	public function getOrdersBy(){
				
		$sales=array();
		
		$args = array(
			  'limit' => -1,
			  'type' => 'shop_order',		
		
		);

		if(!empty($_POST['order_status'] ) ){
						
				$order_status = sanitize_text_field( $_POST['order_status'] );
				$args['status'] = $order_status;
						
		}else $args['status'] = array('wc-completed','wc-processing', 'wc-refunded');
					

		$orders = wc_get_orders( $args ); 
		
		$orders_count = count( $orders );
		if ( $orders_count < 1 ) {
		 echo 'There is no sale yet!';
		}else{	?>
		
		<?php $this->prod_cat_dropdown(); ?>
		<?php
			if(isset($_POST['order_status']) && !empty($_POST['order_status'])){
				print "<h3>". __('Analysis for Orders with Status: ',$this->plugin).esc_attr($_POST['order_status'] )." </h3>";
			}		
		
		?>
		<div class='columns2'>	
			<table class='widefat striped'>
                <thead>
                    <th class="manage-column column-count" scope="col"><?php  esc_html_e('YEAR',$this->plugin);?></th>
					<th class="manage-column column-count" scope="col"><?php  esc_html_e('SALES',$this->plugin);?></th>
					<th class="manage-column column-count" scope="col"><?php  esc_html_e('OF TOTAL SALES %',$this->plugin);?></th>
                </thead>
               
                <tbody>
				 <?php
				 $amount=array();
				 $totals=array();
				 $totalPercent =0;
				 $orderIds=array();
				 $month='';
				 $total='';

				foreach ( $orders as $order ) {
					
					if( isset( $_GET['tab'] ) &&  $_GET['tab'] =='years' ){
						
						$year = date("Y", strtotime( $order->get_date_created() ) );	
						$period = 'YEAR';
						
					}elseif( isset( $_GET['tab'] ) &&  $_GET['tab'] =='months' ){
						
						$year = date("Y-m", strtotime( $order->get_date_created() ) );	
						//$year = $order->get_date_paid() ;	
						$period = 'MONTH';
					}
					
					$total = $order->get_total()-$order->get_total_refunded();					
					$sales[] = array('year'=> $year , 'total'=> $total );						
							
		
				}
				
				
				//SORT ARRAY BY VALUE DESCENDING
				$countSales = array_column($sales, 'year');
				$returnCount = array_multisort($countSales, SORT_DESC , $sales);		
			
				//GROUP BY time period
				$result = array();		
				foreach ($sales as $element) {
				   $result[$element['year']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					foreach ($res as $item) {
						$am += esc_attr($item['total']);

					}
					$percent = (  $item['total'] / $this->total_sales() )*100;
					$percent = round($percent,2) ." %";						
					$totalAmount+= $am;
					
					$reportYear[] = array("year"=>$item['year'],"total"=>$am );
						
					echo "<td>".$item['year']. "</td><td>". wc_price($am) . "</td><td>". $percent . "</td>";	
					print "</tr>";
					 
					 
					array_push($totals,$item['total']);
				}				
				

				print "<tr class='totals'><td>".esc_html__('TOTALS',$this->plugin)."</td><td>" .wc_price($totalAmount) ."</td><td>100%</td></tr>";
				
				$sum = $totalAmount;
				$num = count($sales); 
				$average = $sum / $num;				
				?>			
				</tbody>
			</table>
			
			<?php if( !isset( $_POST['order_status']) && isset( $_GET['tab'] ) &&  $_GET['tab'] =='months' ) {

				if( array_sum ($totals ) != '' ){					
					$forecast = $this->forecastHoltWinters(array_reverse($totals))[0];
				}else $forecast='';

				?>
			
				<div class='report_widget columns2 em'>
					<b><i class='fa fa-2x fa-filter'></i> <?php  esc_html_e('AVERAGE SALES',$this->plugin);?>
					<span><?php print wc_price($average); ?></span>
					</b>
				</div>		
				<div class='report_widget columns2 em'>
					<b><i class='fa fa-2x fa-signal'></i> <?php  esc_html_e('NEXT MONTH SALES FORECAST',$this->plugin);?>
					<span><?php print wc_price( $forecast ); ?></span>
					</b>
				</div>	

			<?php } ?>			
			
		</div>
		

		
				<div class="chart-container columns2" >
					<canvas id="byYear"></canvas>
				</div>
				
				<script>
				var ctx = document.getElementById("byYear");
				var myChart = new Chart(ctx, {
					type: 'bar',
					data: {
						labels: [<?php foreach($reportYear as $order  ){print '"' . esc_attr( $order['year'] ) . '",';};?>],
						datasets: [{
							label: 'Sales',
							data: [<?php foreach($reportYear as $order ){print '"' . $order['total'] . '",';};?>],			
							backgroundColor: [<?php foreach($reportYear as $order ){print '"' .$this->getRandomColor(). '",';};?>],
							borderColor: [<?php foreach($reportYear as $order ){print '"' .$this->getRandomColor(). '",';};?>],
							borderWidth: 1
						}]
					},
					options: {
						title: {
							display: true,
							text: "SALES/ <?php print $period; ?>"
						},		
						scales: {
							yAxes: [{
								ticks: {
									beginAtZero:true
								}
							}]
						}
					}
				});
				</script>				 
				 
                <?php 
		}
	}


	
	
	
	public function prod_cat_dropdown() {?>
		<div class='reportCalendar'>
			<?php $this->selectProduct() ; ?>
			<form method='post'  id='selectDates' autocomplete="off" role="presentation" >
				<input type='text' class='proVersion dateFilter' placeholder='Select Category -PRO' />	

				<select name='order_status' id='order_status' class='dateFilter'>
					<option value=''><?php _e('Order Status', $this->plugin );?></option>
									
						<?php 
							foreach( wc_get_order_statuses() as $key=>$value){
								print "<option value='".esc_attr($key)."' >".esc_attr($value)."</option>";
							}									
						?>

				</select>
				<input type='hidden' name='action' value='get_orders_archive' />
				<input type='submit' class='button button-primary' />				
			</form>
			
		</div>
	
	<?php	
	}

	public function select_dropdown() {
		
		$args = array(
			  'limit' => -1,
			  'type' => 'shop_order',		
			  'status' =>array('wc-completed','wc-processing', 'wc-refunded')
		);		

		$orders = wc_get_orders( $args ); 
		
		$orders_count = count( $orders );
		
		if ( $orders_count < 1 ) {
		 //echo 'There is no sale yet!';
		}else{
		
		$years=array();
		$months = array();
		
		foreach ( $orders as $order ) {
											
			$month = date("Y-m", strtotime( $order->get_date_created() ) );	
			$year = date("Y", strtotime( $order->get_date_created() ) );											
			array_push( $months, $month );
			array_push( $years, $year );									
		}	
	

			
		?>

		<div class='reportCalendar'>
		
		<?php $this->selectProduct() ; ?>
		
		<form method='post'  id='selectDates' autocomplete="off" role="presentation" >	
			<input type='text' class='proVersion dateFilter' readonly placeholder='Select Category -PRO' />

				<select name='order_status' id='order_status' class='dateFilter'>
					<option value=''><?php _e('Order Status', $this->plugin );?></option>
									
						<?php 
							foreach( wc_get_order_statuses() as $key=>$value){
								print "<option value='".esc_attr($key)."' >".esc_attr($value)."</option>";
							}									
						?>

				</select>
				
			<label for="filter-by-date" class="screen-reader-text"><?php esc_html_e( 'Filter by date' ); ?></label>
			<select name="m" class='dateFilter proVersionPreselect' style='background:#eee;' id="pt-filter-by-date">
			<option value=''><?php  esc_html_e('Select Month',$this->plugin);?></option>
			 <?php			
			 $first=0;
			 foreach ( array_unique($months) as $month  ) {
					 $year = strtok( $month, '-' );
					 $month = strtok( '' );
					 print "<option value='proVersionPreselected'>".$month .", ". $year."</option>";
				
				$first = esc_attr( $year . '-' . $month . '-1' );
		    }
				?>
			</select>
			<select name="y" class='dateFilter proVersionPreselect' style='background:#eee;' id="pt-filter-by-year">
				<option value=''><?php  esc_html_e('Select Year',$this->plugin);?></option>
			 <?php
			 foreach ( array_unique($years) as $year )  {
					print "<option value='proVersionPreselected'>".esc_attr( $year )."</option>";
				
			 }
			?>
			</select>

			
			<select name="selected" class='dateFilter proVersionPreselect'>
				<option value=""><?php  esc_html_e('Preselected Period',$this->plugin);?></option>
				<option value="<?php print date('Y-m-d'); ?>"><?php  esc_html_e('Today',$this->plugin);?></option>
				<option value="<?php print date('Y-m-d', strtotime("- 1 day")); ?>"><?php  esc_html_e('Yesterday',$this->plugin);?></option>
				<option value="<?php print date('Y-m-d', strtotime("- 7 days")); ?>"><?php  esc_html_e('This Week',$this->plugin);?></option>
				<option value="<?php print date('Y-m-d', strtotime("first day of this month")); ?>"><?php  esc_html_e('This Month',$this->plugin);?></option>
				<option value="<?php print date('Y-m-d', strtotime("- 2 months")); ?>"><?php  esc_html_e('Last 2 Months',$this->plugin);?></option>
				<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php  esc_html_e('Last 3 Months',$this->plugin);?></option>
				<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php  esc_html_e('Last 6 Months',$this->plugin);?></option>
				<!--<option class='proVersionPreselected' style='background:#eee;' value="proVersionPreselected"><?php // esc_html_e('Get All',$this->plugin);?></option>-->
			</select>			
			
			 <input  placeholder='From'  class="from datepicker dateFilter" readonly name='from' value='' />
			 <input  placeholder='To'  class="to datepicker dateFilter"  readonly name='to' value='' />
			 <?php wp_nonce_field($this->plugin); ?>
			 <input type='submit' class='button button-primary' />
		 </form>
		 
		 </div>
	<?php 
	
		}
	}
	
	public function selectProduct(){
		?>
		<form method='post'  style='display:inline' id='selectProduct' autocomplete="off" role="presentation" >
		<p><span class='button button-primary prodToggler proVersion'><?php  esc_html_e('Select a Product..',$this->plugin);?></span></p>		
		</form>
		<?php
	}

	public function all_sales(){
			
	if($_SERVER['REQUEST_METHOD'] == 'POST' && ( current_user_can('administrator') || current_user_can('shop_manager') ) ) {
		
		check_admin_referer( $this->plugin );
		check_ajax_referer($this->plugin);
	
		if( isset($_POST['selected']) && !empty($_POST['selected']) ){

			$to = date('Y-m-d'); // or your date as well
			$from = $_POST['selected'];	
			
			$datediff = strtotime(date('Y-m-d')) - strtotime($_POST['selected']);
			$datediff = abs(round($datediff / (60 * 60 * 24)));
			
		}else{
			
			$from =  date('Y-m-01');
			$to = date('Y-m-d');
			
			$datediff = strtotime(date('Y-m-d')) - strtotime(date('Y-m-01'));
			$datediff = round($datediff / (60 * 60 * 24));			
		}
		
	}else{ //--> this month
			$from =  date('Y-m-01');
			$to = date('Y-m-d');

			$datediff =  strtotime(date('Y-m-d')) - strtotime(date('Y-m-01'));
			$datediff = round($datediff / (60 * 60 * 24));	
	}
	


	global $woocommerce;

	if( isset( $_REQUEST['order_status'] ) ){
		$order_status = sanitize_text_field( $_REQUEST['order_status'] ); 
		$orderstatus = sanitize_text_field( $_REQUEST['order_status'] ); 
	}else {
		$order_status = array( 'wc-completed','wc-refunded');
		$orderstatus = 'completed'; 
	}
	
	$args = array(
			  'limit' => -1,
			  'type' => 'shop_order',
			  'orderby' => 'date', //has no effect as its a meta field 
			  'order' => 'DESC',
			  'date_completed' => $from."...".$to,
			  'status'       => $order_status,  
	);
	$getorders = wc_get_orders( $args ); 
	
		if( $getorders ){
					
			$sales = array();
			$orders=array();
			$products=array();
			$categories=array();
			$customers=array();
			$countries=array();
			$coupons=array();
			$payments=array();
			$productnames=array();
			$dataPoint = array();
			$catData = array();
			$couponData = array();
			$report = array();			
			$subtotal=0;
			$discount=0;
			$shipping=0;
			$total=0;
			$taxes=0;
			$refunds=0;
			$numOrders = count( $getorders ); 
			$numPro=0;			
			$uniqueDates = array();
			
			
		foreach ( $getorders as $order ){
			

			$items = $order->get_items();
				$names = array();	
							if(empty($orderIds) && !isset( $_POST['cat'] )  && !isset( $_POST['productSelected']) ){
								array_push($uniqueDates,date("d M Y",strtotime($order->get_date_created() ) ));


								if ( version_compare( WC()->version, '3.7', '>=' ) ) {
									$thecoupons = $order->get_coupon_codes();
								}else{
									$thecoupons = $order->get_used_coupons();
								}
								
								$sales[] = array("amount"=>$order->get_total() , "date"=>date("d M Y",strtotime($order->get_date_created() ) ) );
								$payments[] = array('refund'=>$order->get_total_refunded(),"quantity"=>'1',"payment"=>str_replace(" Checkout","",$order->get_payment_method_title()),"amount"=>$order->get_total() , "date"=>date("d M Y",strtotime($order->get_date_created() ) ) );								
								$orders[] = array('refund'=>$order->get_total_refunded(),"orderid"=> $order->get_order_number(),"date"=>date("d M Y",strtotime($order->get_date_created() ) ),"quantity"=>$order->get_item_count(),"payment"=>str_replace(" Checkout","",$order->get_payment_method_title()),"amount"=>$order->get_total(), "refund"=>$order->get_total_refunded(),"tax"=>$order->get_total_tax(), 'discount'=>$order->get_total_discount(), 'shipping'=>$order->get_shipping_total(),'name'=>$order->get_billing_first_name()." ".$order->get_billing_last_name(),'country'=>$order->get_billing_country() , 'coupons' => implode(",",$thecoupons) ,'subtotal'=>$order->get_subtotal() );	

								$customers[] = array('refund'=>$order->get_total_refunded(),"name"=>$order->get_billing_first_name()." ".$order->get_billing_last_name(),"phone"=>$order->get_billing_phone(),"mail"=>$order->get_billing_email(),"country"=>$order->get_billing_country(),"state"=>$order->get_billing_state(),"city"=>$order->get_billing_city(),"quantity"=>$order->get_item_count(),"amount"=>$order->get_total() , "date"=>date("d M Y",strtotime($order->get_date_created() ) ) );				
								$countries[] = array('refund'=>$order->get_total_refunded(),"name"=>$order->get_billing_country(),"amount"=>$order->get_total(),"quantity"=>'1');

								foreach( $thecoupons as $cop ){
									$coupons[] = array("name"=>$cop,"amount"=>$order->get_total_discount());
									$coupons = array_merge($coupons,$couponData);	
								}

								  foreach( $items as $product ) {			
													$products[] = array('discount'=>$order->get_total_discount(),'refund'=>$order->get_total_refunded(),"name"=>$product['name'],"quantity"=>$product['quantity'],"payment"=>str_replace(" Checkout","",$order->get_payment_method_title()),"amount"=>$product['subtotal'] , "date"=>date("d M Y",strtotime($order->get_date_created() ) ) );
													$products = array_merge($products,$dataPoint);		
												$terms = wp_get_post_terms( $product['product_id'],'product_cat');
												if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
													foreach ( $terms as $term ) {
														//echo $term->name .'<br/>';
														//push in arrAY FOR GROUPING
														$categories[] = array('discount'=>$order->get_total_discount(),'refund'=>$order->get_total_refunded(),"name"=>$term->name,"quantity"=>$product['quantity'],"amount"=>$product['subtotal']  );
														$categories = array_merge($categories,$catData);							
													}					
												} 					
									 //push in arrAY FOR GROUPING		
								  }//end of looping items

								$numPro++;
								$subtotal +=$order->get_subtotal();
								$discount+=$order->get_total_discount();
								$shipping+=$order->get_shipping_total();
								$total +=$order->get_total();	
								$refunds +=$order->get_total_refunded();
								$taxes +=$order->get_total_tax();									
							}		
	   }

	
		//FORECAST FOR NEXT MONTH
		$coupSales = array_column($sales, 'date');
		$returnCoup = array_multisort($coupSales, SORT_ASC , $sales);			
		$salesToFor = array();		
		//GROUP SALES BY DATE
		foreach ($sales as $element) {
			$salesToFor[$element['date']][] = $element;
		}	
		$totalAmount=0;
		foreach($salesToFor as $res){			
			//SUM WITHIN MULTIDEMENSIONAL ARRAY
			$am = 0;
			foreach ($res as $item) {
				$am += $item['amount'];
			}				
			$totalAmount+= $am;
		}
		if($subtotal !=''){
		   if( count($uniqueDates) >0 ) $uniqueDates = array_unique($uniqueDates);
		   if( count($uniqueDates) >0  ) $saleEvery = $datediff / count($uniqueDates);
		   $saleEvery =0;
			$avg = $subtotal / $datediff;
			$net = $subtotal - $refunds - $discount;
		}else{
			$numOrders=0;
			$saleEvery =0;
		}
	?>
		
		<div class='overview clearfix'>
			<center>
			<?php
			if(isset($_POST['order_status']) && !empty($_POST['order_status'])){
				$order_status = sanitize_text_field( $_POST['order_status'] );
				print "<h3> ". __('Orders with Status',$this->plugin) ." ".esc_html( $order_status )." </h3>";
			}			
			if( isset( $_POST['selected'] ) && !empty($_POST['selected'])){
				print "<h3>". esc_html__('Analysis for period',$this->plugin)." ".date('d/m/Y',strtotime(esc_attr($_POST['selected'])))." to ".date('d/m/Y')."</h3>";			
			}elseif( isset( $_POST['y'] ) && !empty($_POST['y'])){
				print "<h3>".esc_attr( $_POST['y'] )." ". esc_html__('Analysis',$this->plugin)."</h3>";
			}else print "<h3>". esc_html__('This Month Analysis',$this->plugin)."</h3>";
		
			?>
			</center>
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-signal' ></i> <?php  esc_html_e('TOTAL SALES ',$this->plugin);?> <br/><span><?php print wc_price(esc_attr($total)); ?></span></h3>
					</div>	
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-signal' ></i> <?php  esc_html_e('NET SALES',$this->plugin);?> <br/><span><?php print wc_price(esc_attr($subtotal)); ?></span></h3>
					</div>						
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-signal' ></i> <?php  esc_html_e('SALES',$this->plugin);?> <small style='font-weight:normal'>after refunds&discounts </small><br/><span><?php print wc_price(esc_attr($net)); ?></span></h3>
					</div>										
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-truck' ></i> <?php  esc_html_e('SHIPPING',$this->plugin);?>  <br/><span><?php print wc_price(esc_attr($shipping)) ; ?></span></h3>
					</div>	
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-truck' ></i> <?php  esc_html_e('TAXES',$this->plugin);?>  <br/><span><?php print wc_price(esc_attr($taxes)) ; ?></span></h3>
					</div>					
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-thumbs-down' ></i> <?php  esc_html_e('REFUNDS',$this->plugin);?>  <br/><span><?php print wc_price(esc_attr($refunds)) ; ?></span></h3>
					</div>					
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-tag' ></i> <?php  esc_html_e('DISCOUNT',$this->plugin);?>  <br/><span><?php print wc_price(esc_attr($discount)); ?></span></h3>
					</div>			
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-pie-chart' ></i> <?php  esc_html_e('TOTAL PRODUCTS PURCHASED',$this->plugin);?> <br/><span><?php print esc_attr($numPro); ?></span></h3>
					</div>	
					<div class='columns4 report_widget'>
						<h3 class='text-center'><i class='fa fa-2x fa-pie-chart' ></i> <?php  esc_html_e('TOTAL ORDERS',$this->plugin);?>  <br/><span><?php print esc_attr($numOrders); ?></span></h3>
					</div>	
					<div class='columns4 report_widget em'>
						<h3 class='text-center'><i class='fa fa-2x fa-filter' ></i> <?php  esc_html_e('AVG NET SALES / day',$this->plugin);?>  <br/><span><?php print wc_price(esc_attr($avg)); ?></span></h3>
					</div>						
					<div class='columns4 report_widget em'>
						<h3 class='text-center'><i class='fa fa-2x fa-clock-o' ></i> <?php  esc_html_e('SALES EVERY',$this->plugin);?>  <br/><span><?php print floor(esc_attr($saleEvery)); ?></span> <?php  esc_html_e('DAYS',$this->plugin);?></h3>
					</div>
		</div>		
		
		<?php if($subtotal !=''){ ?>
		
		<div id="tabs2" class='clearfix'>
			<ul>
				<li><a href="#orders"><?php  esc_html_e('Orders',$this->plugin);?></a></li>				
				<li><a href="#customers"><?php  esc_html_e('Customers',$this->plugin);?></a></li>				
				<li><a href="#products"><?php  esc_html_e('Products',$this->plugin);?></a></li>
				<li><a href="#categories"><?php  esc_html_e('Categories',$this->plugin);?></a></li>
				<li><a href="#countries"><?php  esc_html_e('Countries',$this->plugin);?></a></li>
				<li><a href="#payment"><?php  esc_html_e('Payment Methods',$this->plugin);?></a></li>
				<li><a href="#coupons"><?php  esc_html_e('Coupons',$this->plugin);?></a></li>
			</ul>
		<?php $this->orders($orders); ?>
		<?php $this->payments($payments); ?>
		<?php $this->customers($customers); ?>
		<?php $this->countries($countries); ?>
		<?php $this->products($products); ?>
		<?php $this->categories($categories); ?>
		<?php $this->coupons($coupons); ?>
		
		
		</div>
	<?php } ?>
		
		<?php    
		
		}else{
			print "<center>";
			if(isset($_POST['selected']) && !empty($_POST['selected'])){
				print "<h3>".esc_html__('No ',$this->plugin) .$orderstatus. esc_html__(' orders for ',$this->plugin).date('d/m/Y',strtotime(esc_attr($_POST['selected'])))." to ".date('d/m/Y')."</h3>";			
			}elseif(isset($_POST['y']) && !empty($_POST['y'])){
				print "<h3>".esc_html__('No ',$this->plugin) .$orderstatus. esc_html__(' orders for ',$this->plugin).esc_attr($_POST['y'])." Analysis</h3>";
			}else print "<h3>".esc_html__('No ',$this->plugin) .$orderstatus. esc_html__(' orders for ',$this->plugin).date('F')." </h3>";			
			print "</center>";	
		}
	
	}

	public function orders($orders){?>

		<div class='column1' id='orders'>
		<?php if($orders){ ?>
		<h3 class='text-center'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e('ORDERS PLACED',$this->plugin);?> </h3>
		<table class="widefat striped" >
			<thead>
			   <tr class="row-title">
					<th><?php  esc_html_e('Order ID',$this->plugin);?></th>
					<th><?php  esc_html_e('Date',$this->plugin);?></th>
					<th><?php  esc_html_e('Payment Method',$this->plugin);?></th>
					<th><?php  esc_html_e('Coupons',$this->plugin);?></th>
					<th><?php  esc_html_e('Cust Name',$this->plugin);?></th>
					<th><?php  esc_html_e('Cust Country',$this->plugin);?></th>
					<th><?php  esc_html_e('Net Sales',$this->plugin);?></th>
					<th><?php  esc_html_e('Discount',$this->plugin);?></th>
					<th><?php  esc_html_e('Shipping Cost',$this->plugin);?></th>
					<th><?php  esc_html_e('Refunds',$this->plugin);?></th>
					<th><?php  esc_html_e('Taxes',$this->plugin);?></th>
					<th><?php  esc_html_e('Total of Sales',$this->plugin);?></th>	
				</tr>
			</thead>		
			<tbody>
		<?php
			$result = array();	
			$totalAmount=0;
			$totalQuantity=0;
			$totalShipping=0;
			$totalDiscount=0;
			$totalRefund=0;
			$totalSub=0;
			$totalTax=0;
			foreach($orders as $item){			
				print "<tr>";
                $total = esc_attr($item['amount']) - esc_attr($item['refund']);
				$totalAmount+= esc_attr($item['amount']- $item['refund']);
				$totalShipping+= esc_attr($item['shipping']);
				$totalDiscount+= esc_attr($item['discount']);
				$totalRefund+= esc_attr($item['refund']);
				$totalSub+= esc_attr($item['subtotal']);
				$totalTax+= esc_attr($item['tax']);
				
				
				$item['country']!='' ? $item['country'] = WC()->countries->countries[esc_attr($item['country'])] : $item['country']='';
				$item['orderid']!='' ?  : $item['orderid']='';
				$item['date']!='' ? : $item['date']='';
				$item['payment']!='' ? : $item['payment']='';
				$item['coupons']!='' ? : $item['coupons']='';
				$item['name']!='' ? : $item['name']='';
				$item['subtotal']!='' ? : $item['subtotal']='';
				$item['discount']!='' ? : $item['discount']='';
				$item['shipping']!='' ? : $item['shipping']='';
				$item['refund']!='' ? : $item['refund']='';
				$item['tax']!='' ? : $item['tax']='';
				
				echo "<td>";
				?>
					<a target='blank' href="<?php print admin_url( "/admin.php?page=wc-orders&action=edit&id=".$item['orderid'] );?>"><?=$item['orderid']; ?></a>
				
				<?php echo "</td><td>".esc_attr($item['date']). "</td><td>".esc_attr($item['payment']). "</td><td>".esc_attr($item['coupons']). "</td><td>".esc_attr($item['name']). "</td><td>".$item['country']. "</td><td>". wc_price(esc_attr($item['subtotal'])) . "</td><td>". wc_price(esc_attr($item['discount'])) . "</td><td>". wc_price(esc_attr($item['shipping'])) . "</td><td>". wc_price(esc_attr($item['refund'])) . "</td><td>". wc_price(esc_attr($item['tax'])) . "</td><td>". wc_price($total) . "</td>";	
				print "</tr>";
				
			}
			echo "<tr class='totals'><td>".esc_html__('TOTALS',$this->plugin)."</td><td></td><td></td><td></td><td></td><td></td><td>".wc_price($totalSub)."</td><td>".wc_price($totalDiscount)."</td><td>".wc_price($totalShipping)."</td><td>".wc_price($totalRefund)."</td><td>".wc_price($totalTax)."</td><td>".wc_price($totalAmount)."</td></tr>";			
		?>
		   </tbody>
		   <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
		</table>
		
		<?php }else print "<h3>".esc_html__('No data for orders',$this->plugin)."</h3>"; ?>
		</div>	
	<?php
	}
	
	public function payments($payments){
	?>
		<div id='payment'>
		<?php if($payments){ ?>
		
			<div class='columns2'>
			<h3 class='text-center'><i class='fa fa-money' ></i> <?php  esc_html_e('PAYMENT METHODS',$this->plugin);?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Payment Method',$this->plugin);?></th>
						<th><?php  esc_html_e('Orders',$this->plugin);?></th>
						<th><?php  esc_html_e('Sales',$this->plugin);?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$paySales = array_column($payments, 'amount');
				$returnPay = array_multisort($paySales, SORT_DESC , $payments);			
				//GROUP BY PAYMENT METHOD
				$result = array();		
				foreach ($payments as $element) {
				   $result[$element['payment']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					foreach ($res as $item) {
						$am += esc_attr($item['amount'])-esc_attr($item['refund']);
						$quant += esc_attr($item['quantity']);

					}
					$totalAmount+= $am;
					$totalQuantity+= $quant;
					
					$reportPayment[] = array("name"=>esc_attr($item['payment']),"payment"=>$am );
						
					echo "<td>".esc_attr($item['payment']). "</td><td>". $quant . "</td><td>". wc_price($am) . "</td>";	
					print "</tr>";
					
				}
				echo "<tr class='totals'><td>".esc_html__('TOTALS',$this->plugin)."</td><td>".$totalQuantity."</td><td>".wc_price($totalAmount)."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
			</table>
			</div>
				<div class="chart-container columns2" style="position: relative">
					<canvas id="byPayment"></canvas>
				</div>

				<script>
				var ctx = document.getElementById("byPayment");
				var myChart = new Chart(ctx, {
					type: 'bar',
					data: {
						labels: [<?php foreach($reportPayment as $t){print '"' .esc_attr($t['name']) . '",';};?>],
						datasets: [{
							label: 'Sales',
							data: [<?php foreach($reportPayment as $t){print '"' .esc_attr($t['payment']) . '",';};?>],			
							backgroundColor: [
								<?php foreach($reportPayment as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderColor: [
								<?php foreach($reportPayment as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderWidth: 1
						}]
					},
					options: {
						title: {
							display: true,
							text: 'Payment Methods'
						},		
						scales: {
							yAxes: [{
								ticks: {
									beginAtZero:true
								}
							}]
						}
					}
				});
				</script>
		<?php }else print "<h3>".esc_html__('No data for payments',$this->plugin)."</h3>"; ?>
		</div>
	<?php
	}
	
	public function customers($customers){
		?>
		<div class='column1' id='customers'>
		<?php if($customers){ ?>
		<h3 class='text-center'><i class='fa fa-users' ></i> <?php  esc_html_e('CUSTOMERS',$this->plugin);?> </h3>
		<table class="widefat striped" id='custs'>
			<thead>
			   <tr class="row-title">
					<th><?php  esc_html_e('Customer Name',$this->plugin);?></th>
					<th><?php  esc_html_e('Phone',$this->plugin);?></th>
					<th><?php  esc_html_e('Email',$this->plugin);?></th>
					<th><?php  esc_html_e('Country',$this->plugin);?></th>
					<th><?php  esc_html_e('State',$this->plugin);?></th>
					<th><?php  esc_html_e('City',$this->plugin);?></th>
					<th><?php  esc_html_e('Quantity',$this->plugin);?></th>
					<th><?php  esc_html_e('Sales',$this->plugin);?></th>
				</tr>
			</thead>		
			<tbody>
		<?php
			//SORT ARRAY BY VALUE DESCENDING
			$custSales = array_column($customers, 'amount');
			$returnCust = array_multisort($custSales, SORT_DESC , $customers);		
			//GROUP BY CUSTOMER
			$result = array();		
			foreach ($customers as $element) {
			   $result[$element['name']][] = $element;
			}
			//run the loop, sum the salaries by gender
			$totalAmount=0;
			$totalQuantity=0;
			foreach($result as $res){			
				print "<tr>";
				/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
				$am = 0;
				$quant=0;
				foreach ($res as $item) {
					$am += esc_attr($item['amount'])-esc_attr($item['refund']);
					$quant += esc_attr($item['quantity']);

				}
				$totalAmount+= $am;
				$totalQuantity+= $quant;
				$item['country']!='' ? $item['country'] = WC()->countries->countries[esc_attr($item['country'])] : $item['country']='';
				
					//$report[] = array("name"=>esc_attr($item['payment']),"quantity"=>$am,"payment"=>$quant );
					
				echo "<td>".esc_attr($item['name']). "</td><td>".esc_attr($item['phone']). "</td><td>".esc_attr($item['mail']). "</td><td>".$item['country']. "</td><td>".esc_attr($item['state']). "</td><td>".esc_attr($item['city']). "</td><td>". $quant . "</td><td>". wc_price($am) . "</td>";	
				print "</tr>";
				
			}
			echo "<tr class='totals'><td>".esc_html__('TOTALS',$this->plugin)."</td><td></td><td></td><td></td><td></td><td></td><td>".$totalQuantity."</td><td>".wc_price($totalAmount)."</td></tr>";			
		?>
		   </tbody>
		   <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
		</table>
		<?php }else print "<h3>".esc_html__('No data for customers',$this->plugin)."</h3>"; ?>
		</div>		
	<?php
	
	}
	
	
	public function countries($countries){
		?>
	
		<div  id='countries'>
		<?php if($countries){ ?>
			<div class='columns2' >
			<h3 class='text-center'><i class='fa fa-globe' ></i> <?php  esc_html_e('COUNTRIES',$this->plugin);?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Country',$this->plugin);?></th>
						<th><?php  esc_html_e('Orders',$this->plugin);?></th>
						<th><?php  esc_html_e('Sales',$this->plugin);?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$countSales = array_column($countries, 'amount');
				$returnCount = array_multisort($countSales, SORT_DESC , $countries);		
			
				//GROUP BY country
				$result = array();		
				foreach ($countries as $element) {
				   $result[$element['name']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					foreach ($res as $item) {
						$am += esc_attr($item['amount'])-esc_attr($item['refund']);
						$quant += esc_attr($item['quantity']);

					}
					$totalAmount+= $am;
					$totalQuantity+= $quant;
					
					$item['name']!='' ? $item['name'] = WC()->countries->countries[esc_attr($item['name'])] : $item['name']='';
					
					$reportCountries[] = array("name"=>$item['name'],"quantity"=>$quant,"payment"=>$am );
						
					echo "<td>".$item['name']. "</td><td>". $quant . "</td><td>". wc_price($am) . "</td>";	
					print "</tr>";
					 
				}
				echo "<tr class='totals'><td>".esc_html__('TOTALS',$this->plugin)."</td><td>".$totalQuantity."</td><td>".wc_price($totalAmount)."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
			</table>
			</div>		
				<div class="chart-container columns2" >
					<canvas id="byCountry"></canvas>
				</div>

				<script>
				var ctx = document.getElementById("byCountry");
				var myChart = new Chart(ctx, {
					type: 'bar',
					data: {
						labels: [<?php foreach($reportCountries as $t){print '"' .esc_attr($t['name']) . '",';};?>],
						datasets: [{
							label: 'Sales',
							data: [<?php foreach($reportCountries as $t){print '"' .esc_attr($t['payment']) . '",';};?>],			
							backgroundColor: [
								<?php foreach($reportCountries as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderColor: [
								<?php foreach($reportCountries as $t){print '"' .$this->getRandomColor(). '",';};?>],
							borderWidth: 1
						}]
					},
					options: {
						title: {
							display: true,
							text: 'Countries'
						},		
						scales: {
							yAxes: [{
								ticks: {
									beginAtZero:true
								}
							}]
						}
					}
				});
				</script>
		<?php }else print "<h3>".esc_html__('No data for countries',$this->plugin)."</h3>"; ?>
		</div>	
	<?php
	}
	
	public function products($products){ 
	?>
		<div id='products'>
		<?php if($products){ ?>
			<div class='column1'>
			<h3 class='text-center'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e('PRODUCTS',$this->plugin);?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Product',$this->plugin);?></th>
						<th><?php  esc_html_e('Items Sold',$this->plugin);?></th>
						<th><?php  esc_html_e('Sales',$this->plugin);?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
		
				//SORT ARRAY BY VALUE DESCENDING
				$prodSales = array_column($products, 'amount');
				$returnProd = array_multisort($prodSales, SORT_DESC , $products);
				
				//GROUP BY products
				$result = array();		
				foreach ($products as $element) {
				   $result[$element['name']][] = $element;
				}
				
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				$totalRefund = 0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					foreach ($res as $item) {
						$am += esc_attr($item['amount'])-esc_attr($item['refund'])-esc_attr($item['discount']);
						$quant += esc_attr($item['quantity']);
                        $totalRefund= esc_attr($item['refund']);
					}
					$totalAmount+= $am;
					$totalQuantity+= $quant;
					
						$reportProducts[] = array("name"=>esc_attr($item['name']),"quantity"=>$am,"amount"=>$am );
						
					echo "<td>".esc_attr($item['name']). "</td><td>". $quant . "</td><td>". wc_price($am) . "</td>";	
					print "</tr>";
					
				}
				echo "<tr class='totals'><td>".esc_html__('TOTALS',$this->plugin)."</td><td>".$totalQuantity."</td><td>".wc_price($totalAmount)."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
			</table>
			</div>		
			<div class="chart-container" >
				<canvas id="productChart"></canvas>
			</div>

			<script>
			var ctx = document.getElementById("productChart");
			var myChart = new Chart(ctx, {
				type: 'bar',
				data: {
					labels: [<?php foreach($reportProducts as $p){print '"' . esc_attr($p['name']) . '",';};?>],
					datasets: [{
						label: '# of Sales',
						data: [<?php foreach($reportProducts as $p){print '"' . esc_attr($p['amount']) . '",';};?>],
						backgroundColor:[<?php foreach($reportProducts as $p){print '"' .$this->getRandomColor(). '",';};?>],				
						borderColor:[<?php foreach($reportProducts as $p){print '"' .$this->getRandomColor(). '",';};?>],				
						borderWidth: 1
					}]
				},
				options: {
					title: {
						display: true,
						text: 'PRODUCTS'
					},		
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true
							}
						}]
					}
				}
			});
			</script>
			
		<?php }else print "<h3>".esc_html__('No data for products',$this->plugin)."</h3>"; ?>
		</div>		
	<?php

	}
	
	public function categories($categories){
			
	?>
		<div id='categories'>
		<?php if($categories){ ?>
			<div class='columns2'>
			<h3 class='text-center'><i class='fa fa-tag' ></i> <?php  esc_html_e('CATEGORIES',$this->plugin);?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Category',$this->plugin);?></th>
						<th><?php  esc_html_e('Items Sold',$this->plugin);?></th>
						<th><?php  esc_html_e('Sales',$this->plugin);?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$catSales = array_column($categories, 'amount');
				$returnCat = array_multisort($catSales, SORT_DESC , $categories);		
				//GROUP BY products
				$result = array();		
				foreach ($categories as $element) {
				   $result[$element['name']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				$totalQuantity=0;
				$totalRefund=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					$quant=0;
					foreach ($res as $item) {
					    $am += esc_attr($item['amount'])-esc_attr($item['refund'])-esc_attr($item['discount']);
						$quant += esc_attr($item['quantity']);
                         $totalRefund= esc_attr($item['refund']);
					}
					$totalAmount+= $am;
					$totalQuantity+= $quant;				
					$reportCategories[] = array("name"=>esc_attr($item['name']),"amount"=>$am );
						
					echo "<td>".esc_attr($item['name']). "</td><td>". $quant . "</td><td>". wc_price($am) . "</td>";	
					print "</tr>";
					
				}
				echo "<tr class='totals'><td>".esc_html__('TOTALS',$this->plugin)."</td><td>".$totalQuantity."</td><td>".wc_price($totalAmount)."</td></tr>";			
			?>
			   </tbody>
			   <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
			</table>
			</div>
			<div class="chart-container columns2" >
				<canvas id="couponCategories"></canvas>
			</div>
			<script>
			var ctx = document.getElementById("couponCategories");
			var myChart = new Chart(ctx, {
				type: 'pie',
				data: {
					labels: [<?php foreach($reportCategories as $rep){print '"' . esc_attr($rep['name']) . '",';};?>],
					datasets: [{
						label: '',
						data: [<?php foreach($reportCategories as $rep){print '"' .  esc_attr($rep['amount']) . '",';};?>],
						backgroundColor:[<?php foreach($reportCategories as $rep){print '"' .$this->getRandomColor(). '",';};?>],				
						borderColor:[<?php foreach($reportCategories as $rep){print '"' .$this->getRandomColor(). '",';};?>],					
						borderWidth: 1
					}]
				},
				options: {
					title: {
						display: true,
						text: 'Categories'
					},		
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true
							}
						}]
					}
				}
			});
			</script>			
		<?php }else print "<h3>".esc_html__('No data for categories',$this->plugin)."</h3>"; ?>
		</div>	
	
	<?php	

	}
	
	public function coupons($coupons){	
		?>
		<div id='coupons'>
		<?php if($coupons){ ?>
			<div class='columns2'>
			<h3 class='text-center'><i class='fa fa-tag' ></i> <?php  esc_html_e('COUPONS',$this->plugin);?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Coupon',$this->plugin);?></th>
						<th><?php  esc_html_e('Total',$this->plugin);?></th>
					</tr>
				</thead>		
				<tbody>
			<?php
				//SORT ARRAY BY VALUE DESCENDING
				$coupSales = array_column($coupons, 'amount');
				$returnCoup = array_multisort($coupSales, SORT_DESC , $coupons);				
				//GROUP BY coupons
				$result = array();	
				foreach ($coupons as $element) {
				   $result[$element['name']][] = $element;
				}
				//run the loop, sum the salaries by gender
				$totalAmount=0;
				foreach($result as $res){			
					print "<tr>";
					/*SUM WITHIN MULTIDEMENSIONAL ARRAY*/
					$am = 0;
					foreach ($res as $item) {
						$am += esc_attr($item['amount']);
					}				
					$totalAmount+= $am;
					$reportCoupons[] = array("name"=>esc_attr($item['name']),"amount"=>$am );
					echo "<td>".esc_attr($item['name']). "</td><td>". wc_price($am) . "</td>";	
					print "</tr>";
					
				}			
				echo "<tr class='totals'><td>".__('TOTALS',$this->plugin)."</td><td>".wc_price($totalAmount)."</td></tr>";			
			?>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
			</table>
			</div>	
			<div class="chart-container columns2" >
				<canvas id="couponCharts"></canvas>
			</div>
			<script>
			var ctx = document.getElementById("couponCharts");
			var myChart = new Chart(ctx, {
				type: 'pie',
				data: {
					labels: [<?php foreach($reportCoupons as $rep){print '"' . esc_attr($rep['name']) . '",';};?>],
					datasets: [{
						label: '',
						data: [<?php foreach($reportCoupons as $rep){print '"' .  esc_attr($rep['amount']) . '",';};?>],
						backgroundColor:[<?php foreach($reportCoupons as $rep){print '"' .$this->getRandomColor(). '",';};?>],				
						borderColor:[<?php foreach($reportCoupons as $rep){print '"' .$this->getRandomColor(). '",';};?>],					
						borderWidth: 1
					}]
				},
				options: {
					title: {
						display: true,
						text: 'Coupons'
					},		
					scales: {
						yAxes: [{
							ticks: {
								beginAtZero:true
							}
						}]
					}
				}
			});
			</script>	
		<?php }else print "<h3>".esc_html__('No data for coupons',$this->plugin)."</h3>"; ?>
		</div>	
	<?php
	
	}
	
	public function topSellers(){
			global $woocommerce;		
            include_once(WC()->plugin_path().'/includes/admin/reports/class-wc-admin-report.php');
                $wc_report = new WC_Admin_Report();
 
                $data = $wc_report->get_order_report_data( array(
                    'data' => array(
                        '_qty' => array(
                            'type' => 'order_item_meta',
                            'order_item_type' => 'line_item',
                            'function' => 'SUM',
                            'name' => 'quantity'
                        ),
                        '_line_subtotal' => array(
                            'type' => 'order_item_meta',
                            'order_item_type' => 'line_item',
                            'function' => 'SUM',
                            'name' => 'gross'
                        ),
                        '_product_id' => array(
                            'type' => 'order_item_meta',
                            'order_item_type' => 'line_item',
                            'function' => '',
                            'name' => 'product_id'
                        ),
                        'order_item_name' => array(
                            'type'     => 'order_item',
                            'function' => '',
                            'name'     => 'order_item_name',
                        ),
                    ),           
                    'group_by'     => 'product_id',           
                    'order_by'     => 'quantity DESC',           
                    'query_type' => 'get_results',
            
                    'limit' => 5,
                    'order_types' => wc_get_order_types( 'order_count' ),
                    'order_status' => array( 'completed','processing','onhold','refunded'),
                ) );
				
				if(!empty($data)){
                ?><br/><hr/>
				<h3 class='text-center'><i class='fa fa-tag' ></i> <?php  esc_html_e('ALL TIMES TOP 5 SELLING PRODUCTS',$this->plugin);?></h3>
                <table class='widefat striped'>
                    <thead>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Category',$this->plugin);?></th>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Product',$this->plugin);?></th>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Quantity',$this->plugin);?></th>
                        <th class="manage-column column-count" scope="col"><?php  esc_html_e('Sales',$this->plugin);?></th>
                    </thead>
               
                    <tbody>
                        
                    <?php
                    foreach($data as $d){
                        $terms = wp_get_post_terms( $d->product_id, 'product_cat' );
                        print "<tr><td>";
                        foreach ( $terms as $term ) {
                             $cat_id = $term->name;
                             print $term->name ."<br/>";
                             
                        }
                        //$d->product_id 
                        print "</td>";
                        print "<td>".esc_attr($d->order_item_name) . "</td><td>".esc_attr($d->quantity)."</td><td>" .wc_price(esc_attr($d->gross)) ."</td>" ;
                        print "</tr>";
                    }
                    ?>
                    </tbody>
                 </table>                
                <?php 
				}else print esc_html__("There is no sale yet!",$this->plugin);
	}		
		

	public function LowStock(){
			?>
		<div id='noselling'>
			<div class='column1'>
			<h3 class='text-center title'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e('All Time Low Stock Products( < 5 items )',$this->plugin);?></h3>
			<table class='widefat'>
			<thead>
				<tr>
					<th><?php  esc_html_e('Title',$this->plugin);?></th>
					<th><?php  esc_html_e('Stock',$this->plugin);?></th>
					<th><?php  esc_html_e('Sales',$this->plugin);?></th>
				</tr>
			</thead>
			<tbody>
			<tr><td rowspan="3"><h1 class='proVersion'><a href='#'><?php  esc_html_e('PRO VERSION ONLY- get it Here!',$this->plugin);?></a></h1></td></tr>
		</tbody> 
		 <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
		</table>
		</div>
	<?php	
	}

	public function sellingProdStock(){
		?>
		<div id='selling'>
			<div class='column1'>
			<h3 class='text-center'><i class='fa fa-pie-chart' ></i> <?php  esc_html_e('Last 30 days Selling Products Stock Reminder',$this->plugin);?></h3>
			<table class="widefat striped" >
				<thead>
				   <tr class="row-title">
						<th><?php  esc_html_e('Product',$this->plugin);?></th>
						<th><?php  esc_html_e('Items Sold',$this->plugin);?></th>
						<th><?php  esc_html_e('In Stock',$this->plugin);?></th>						
						<th><?php  esc_html_e('Sales Amount',$this->plugin);?></th>
						<th><?php  esc_html_e('Sales Every (days)',$this->plugin);?></th>
						<th><?php  esc_html_e('Avg Quantity Sold / Order',$this->plugin);?></th>
						<th><?php  esc_html_e('Next Order Forecasted Quantity',$this->plugin);?></th>
						<th><?php  esc_html_e('Days Left to Out of Stock',$this->plugin);?></th>
					</tr>
				</thead>		
				<tbody>
					<tr><td rowspan="8"><h1 class='proVersion '><a href='#'><?php  esc_html_e('PRO VERSION ONLY- get it Here!',$this->plugin);?></a></h1></td></tr>
			   </tbody>
			    <button class='proVersion'><i class='fa fa-file-excel-o '></i> <?php  esc_html_e('Export / PRO',$this->plugin);?></button><input type="text" class="search proVersion" readonly placeholder="<?php  esc_html_e('Search / PRO.',$this->plugin);?>"></input>
			</table>
			</div>	
		</div>
		<?php
	}	
	
	public function forecastHoltWinters($anData, $nForecast = 2, $nSeasonLength = 4, $nAlpha = 0.2, $nBeta = 0.01, $nGamma = 0.01, $nDevGamma = 0.1) {
		$search = '0';
		$replace = '0.1';
		array_walk($anData,
			function (&$v) use ($search, $replace){
				$v = str_replace($search, $replace, $v);    
			}                                                                     
		);	
		
		$i=1;
		// Calculate an initial trend level
		$nTrend1 = '';
		for($i = 0; $i < $nSeasonLength; $i++) {
			$anData[$i] = isset($anData[1]) ? $anData[1] : null;
		    //$nTrend1 += $anData[$i];
		}
		$nTrend1 = $nSeasonLength;

		$nTrend2 = 1;
		for($i = $nSeasonLength; $i < 2*$nSeasonLength; $i++) {
			$anData[$i] = isset($anData[1]) ? $anData[1] : null;
		  $nTrend2 += $anData[$i];
		}
		$nTrend2 /= $nSeasonLength;

		$nInitialTrend = ($nTrend2 - $nTrend1) / $nSeasonLength;

		// Take the first value as the initial level
		$nInitialLevel = $anData[0];

		// Build index
		$anIndex = array();
		foreach($anData as $nKey => $nVal) {
			$anIndex[$nKey] = $nVal / ($nInitialLevel + ($nKey + 1) * $nInitialTrend);		  
		}

		// Build season buffer
		$anSeason = array_fill(0, count($anData), 0);
		for($i = 0; $i < $nSeasonLength; $i++) {
		  $anSeason[$i] = ($anIndex[$i] + $anIndex[$i+$nSeasonLength]) / 2;
		}

		// Normalise season
		 $Total = array_sum($anSeason);
		 $Total = isset($Total) & !empty($Total) ? $Total : '0.1';
		 
		$nSeasonFactor = $nSeasonLength / $Total;
		foreach($anSeason as $nKey => $nVal) {
		  $anSeason[$nKey] *= $nSeasonFactor;
		}

		$anHoltWinters = array();
		$anDeviations = array();
		$nAlphaLevel = $nInitialLevel;
		$nBetaTrend = $nInitialTrend;
		foreach($anData as $nKey => $nVal) {
		  $nTempLevel = $nAlphaLevel;
		  $nTempTrend = $nBetaTrend;

		  $nAlphaLevel = @($nAlpha * $nVal / $anSeason[$nKey]) + (1.0 - $nAlpha) * ($nTempLevel + $nTempTrend);
		  $nBetaTrend = $nBeta * ($nAlphaLevel - $nTempLevel) + ( 1.0 - $nBeta ) * $nTempTrend;

		  $anSeason[$nKey + $nSeasonLength] = $nGamma * $nVal / $nAlphaLevel + (1.0 - $nGamma) * $anSeason[$nKey];

		  $anHoltWinters[$nKey] = ($nAlphaLevel + $nBetaTrend * ($nKey + 1)) * $anSeason[$nKey];
		  $anDeviations[$nKey] = $nDevGamma * abs($nVal - $anHoltWinters[$nKey]) + (1-$nDevGamma) 
					  * (isset($anDeviations[$nKey - $nSeasonLength]) ? $anDeviations[$nKey - $nSeasonLength] : 0);
		}

		$anForecast = array();
		$nLast = end($anData);
		for($i = 1; $i <= $nForecast; $i++) {
		   $nComputed = round($nAlphaLevel + $nBetaTrend * $anSeason[$nKey + $i]);
		   if ($nComputed < 0) { // wildly off due to outliers
			 $nComputed = $nLast;
		   }
		   $anForecast[] = $nComputed;
		}

		return $anForecast;
	}
	
	public function Median($Array) {
	  return Quartile_50($Array);
	}
	 
	public function Quartile_25($Array) {
	  return Quartile($Array, 0.25);
	}
	 
	public function Quartile_50($Array) {
	  return Quartile($Array, 0.5);
	}
	 
	public function Quartile_75($Array) {
	  return Quartile($Array, 0.75);
	}
	 
	public function Quartile($Array, $Quartile) {
	  $pos = (count($Array) - 1) * $Quartile;
	 
	  $base = floor($pos);
	  $rest = $pos - $base;
	 
	  if( isset($Array[$base+1]) ) {
		return $Array[$base] + $rest * ($Array[$base+1] - $Array[$base]);
	  } else {
		return $Array[$base];
	  }
	}
	 
	public function Average($Array) {
	  return array_sum($Array) / count($Array);
	}
	 
	public function StdDev($Array) {
	  if( count($Array) < 2 ) {
		return;
	  }
	 
	  $avg = Average($Array);
	 
	  $sum = 0;
	  foreach($Array as $value) {
		$sum += pow($value - $avg, 2);
	  }
	 
	  return sqrt((1 / (count($Array) - 1)) * $sum);
	}

	public function random_color_part() {
		return str_pad( dechex( mt_rand( 0, 255 ) ), 2, '0', STR_PAD_LEFT);
	}

	public function getRandomColor() {
		return "#".$this->random_color_part() . $this->random_color_part() . $this->random_color_part();
	}
	
	public function extensions(){
		
		if( is_admin() && current_user_can( 'administrator' ) ){
			
			$response = wp_remote_get( "https://extend-wp.com/wp-json/products/v2/product/category/excel" );
			if( is_wp_error( $response ) ) {
				return;
			}		
			$posts = json_decode( wp_remote_retrieve_body( $response ) );

			if( empty( $posts ) ) {
				return;
			}

			if( !empty( $posts ) ) {
				echo "<div id='extendwp_extensions_popup'>";
					echo "<div class='extendwp_extensions_content '>";	
						?>
						<span class="extendwp_close">&times;</span>
						<h2><i><?php esc_html_e( 'More Plugins to Make your life easier by ExtendWP!', $this->plugin ); ?></i></h2>
						<hr/>
						<?php
						print "<div class='extend_flex'>";
						foreach( $posts as $post ) {
							
							if( $post->class == 'webdWoocommerceReportingStatisticsPro'   ){
								

							}else{
								
								echo "<div class='columns3'><a target='_blank' href='".esc_url( $post->url )."' /><img src='".esc_url( $post->image )."' /></a>
								<h3><a target='_blank' href='".esc_url( $post->url )."' />". esc_html( $post->title ) . "</a></h3>
								<div>". wp_kses( $post->excerpt, $this->allowed_html )."</div>
								<a class='button_extensions button-primary' target='_blank' href='".esc_url( $post->url )."' />". esc_html__( 'Get it here', $this->plugin ) . " <i class='fa fa-angle-double-right'></i></a>
								</div>";								
							}
							

						}
						print "</div>";
					echo '</div>';
				echo '</div>';	
			}
		
		}
	}	
 }