<?php
/*
 * Plugin Name: Advanced WooCommerce Product Sales Reporting - Statistics & Forecast
 * Plugin URI: https://extend-wp.com/advanced-reporting-statistics-plugin-for-woocommerce/
 * Description: A comprehensive WordPress Plugin for WooCommerce Reports, Statistics, Analytics & Forecasting Tool for Orders, Sales, Products, Countries, Payment Gateways Shipping, Tax, Refunds, Top Products.
 * Version: 2.7
 * Author: extendWP
 * Author URI: https://extend-wp.com
 *
 * WC requires at least: 2.2
 * WC tested up to: 8.7
 * 
 * License: GPL2
 * Created On: 23-01-2019
 * Updated On: 08-04-2024
 */
 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

include_once( plugin_dir_path(__FILE__) ."/class-admin.php"); 
 
 class webdWoocommerceReportingStatistics extends webdWoocommerceReportingStatisticsAdmin{
		
		public $plugin = 'webdWoocommerceReportingStatistics';		
		public $name = 'Webd Woocommerce Advanced Reporting & Statistics';
		public $shortName = 'Reporting & Statistics';
		public $slug = 'webd-woocommerce-reporting-statistics';
		public $dashicon = 'dashicons-editor-table';
		public $proUrl = 'https://extend-wp.com/product/woocommerce-advanced-reporting-statistics/';
		public $menuPosition ='50';
		public $localizeBackend;
		public $localizeFrontend;
		public $description = 'Advanced Reporting Analytics and Statistical Analysic to manage Woocommerce Eshop efficiently.';
			
 
		public function __construct() {
			
			add_action('admin_enqueue_scripts', array($this, 'BackEndScripts') );
			add_action('admin_menu', array($this, 'SettingsPage') );
			add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), array($this, 'Links') );
						

			if ( ! wp_next_scheduled( 'fetchOrders_for_stats' ) && get_option('fetchOrders_for_stats') !='finished' ) {
				wp_schedule_single_event( time(), 'fetchOrders_for_stats' );
				
			}
			add_action( 'fetchOrders_for_stats', array( $this, 'fetchOrders_for_stats') );
			add_action( 'woocommerce_after_order_object_save', array($this, 'update_orders'), 10, 1 );
			add_action( 'admin_notices', array($this, 'pending_orders_notice') );
			
			register_activation_hook( __FILE__,  array($this, 'onActivation') );
			register_deactivation_hook( __FILE__,  array($this, 'onDeactivation') );
			
			add_action('plugins_loaded', 'translate');	
			add_action("admin_init", array($this, 'settingsSection') );				
			add_action("admin_footer", array($this,"proModal" ) );

			add_action( 'wp_ajax_nopriv_stat_extensions', array( $this,'extensions' ) );
			add_action( 'wp_ajax_stat_extensions', array( $this,'extensions' ) );

			add_action( 'before_woocommerce_init', function() {
				if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
					\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
				}
			} );
			
			// deactivation survey 

			include( plugin_dir_path(__FILE__) .'/lib/codecabin/plugin-deactivation-survey/deactivate-feedback-form.php');	
			add_filter('codecabin_deactivate_feedback_form_plugins', function($plugins) {

				$plugins[] = (object)array(
					'slug'		=> 'webd-woocommerce-advanced-reporting-statistics',
					'version'	=> '2.7'
				);

				return $plugins;

			});	
			
			register_activation_hook( __FILE__, array( $this, 'notification_hook' ) );

			add_action( 'admin_notices', array( $this,'notification' ) );
			add_action( 'wp_ajax_nopriv_push_not',array( $this, 'push_not'  ) );
			add_action( 'wp_ajax_push_not', array( $this, 'push_not' ) );	

		
		}

		public function notification(){

			$screen = get_current_screen();
			if ( 'woocommerce_page_webd-woocommerce-reporting-statistics'  !== $screen->base )
			return;
		
			/* Check transient, if available display notice */
			if( get_transient( $this->plugin ."_notification" ) ){
				?>
				<div class="updated notice  webdWoocommerceReportingStatistics_notification">
					<a href="#" class='dismiss' style='float:right;padding:4px' >close</a>
					<h4><i><?php print $this->name;?> | <?php esc_html_e( "Add your Email below & get ", 'imue' ); ?><strong>discounts</strong><?php esc_html_e( " in our pro plugins at", 'webd-woocommerce-reporting-statistics' ); ?> <a href='https://extend-wp.com' target='_blank' >extend-wp.com!</a></i></h4>
					
					<form method='post' id='webdWoocommerceReportingStatistics_signup'>
						<p>
						<input required type='email' name='woopei_email' />
						<input required type='hidden' name='product' value='2071' />
						<input type='submit' class='button button-primary' name='submit' value='<?php esc_html_e("Sign up", "webd-woocommerce-reporting-statistics" ); ?>' />
						</p>
					</form>
				</div>
				<?php
			}
		}


		public function push_not(){
			
			delete_transient( $this->plugin ."_notification" );
					
		}		
		public function notification_hook() {
			set_transient( $this->plugin ."_notification", true );
		}

		public function translate() {
			load_plugin_textdomain( $this->slug, false, dirname( plugin_basename(__FILE__) ) . '/lang/' );
		}

		public function onActivation(){
			require_once(ABSPATH .'/wp-admin/includes/plugin.php');
			$pro = "/woocommerce-reporting-statistics-pro/woocommerce-reporting-statistics-pro.php";
			deactivate_plugins($pro);				
		}
		
		public function onDeactivation() {

			if( file_exists( plugin_dir_path( __FILE__ ).'orders.txt' ) ){
				$filename = plugin_dir_path( __FILE__ ) . 'orders.txt';
				wp_delete_file( $filename );	
			}
			if( file_exists( plugin_dir_path( __FILE__ ).'products.txt' ) ){
				$filename = plugin_dir_path( __FILE__ ) . 'products.txt';
				wp_delete_file( $filename );	
			}				
			remove_action('fetchOrders_for_stats', array($this, 'fetchOrders_for_stats') );
			wp_clear_scheduled_hook( 'fetchOrders_for_stats' );
		
		}
		
		public function BackEndScripts(){
			
			//$screen = get_current_screen();
			//var_dump( $screen );
			//if ( 'woocommerce_page_webd-woocommerce-reporting-statistics'  !== $screen->base )
			//return;
		
			wp_enqueue_style( "webd-woocommerce-reporting-statistics"."adminCss", plugins_url( "/css/backend.css?v=50r", __FILE__ ) );	
			wp_enqueue_style( "webd-woocommerce-reporting-statistics"."adminCss");	
			
			wp_enqueue_script('jquery');
            wp_enqueue_script( 'jquery-ui-datepicker' );
		    wp_enqueue_style( 'jquery-ui-style', plugins_url( "/css/jquery-ui.css", __FILE__ ), true);
			wp_enqueue_script('jquery-ui-accordion');
			wp_enqueue_script("jquery-ui-tabs");			
			wp_enqueue_script( "webd-woocommerce-reporting-statistics"."charts", plugins_url( "/js/chart.js", __FILE__ ), null, true);			
			wp_enqueue_script( "webd-woocommerce-reporting-statistics"."adminJs", plugins_url( "/js/backend.js?v=50r", __FILE__ ) , array('jquery','jquery-ui-accordion','jquery-ui-tabs','jquery-ui-datepicker') , null, true);	
						
			wp_enqueue_style( "webd-woocommerce-reporting-statistics"."_fa", plugins_url( '/css/font-awesome.min.css', __FILE__ ));
			
			$this->localizeBackend = array(
				'thispluginpage'=> admin_url("/admin.php?page=".$this->slug),
				'url' => admin_url( 'admin-ajax.php' ),
				'plugin_url' => plugins_url( '', __FILE__ ),
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'siteUrl'	=>	site_url(),
				'plugin_wrapper'=> "webd-woocommerce-reporting-statistics",
			);		
			wp_localize_script("webd-woocommerce-reporting-statistics"."adminJs", "webd-woocommerce-reporting-statistics" , $this->localizeBackend );
			wp_enqueue_script( "webd-woocommerce-reporting-statistics"."adminJs");
		}

		
		public function SettingsPage(){
			add_submenu_page( 'woocommerce', $this->shortName, $this->shortName, 'manage_woocommerce', $this->slug, array($this, 'init') );	
		}
		
		public function Links($links){
			$mylinks=array();
			$mylinks[] .=  '<a href="' . admin_url( "admin.php?page=".$this->slug ) . '">' . esc_html__( "Reports", "webd-woocommerce-reporting-statistics" ) . '</a>';
			$mylinks[] .=  '<a target="_blank" href="' . $this->proUrl . '">' . esc_html__( "PRO Version", "webd-woocommerce-reporting-statistics" ) . '</a>';
			return array_merge( $links, $mylinks );
		}

		public function init(){
			print "<div class='". $this->plugin ."'>";
			$this->adminHeader();
			$this->adminSettings();
			$this->adminFooter();
			print "</div>";
		}
		public function initStats(){
			print "<div class='". $this->plugin ."'>";
			$this->adminHeader();
			echo "<h3>". esc_html__('Statistics',"webd-woocommerce-reporting-statistics") ."</h3>";
			echo do_shortcode( '[adStats]' );
			
			$this->adminFooter();
			print "</div>";
		}
		
 }
 $initialize = new webdWoocommerceReportingStatistics();