<?php
/* Custom functions code goes here. */

add_filter('woocommerce_email_subject_new_order', 'change_admin_email_subject', 1, 2);

function change_admin_email_subject( $subject, $order ) {

	global $woocommerce;
    $user = wp_get_current_user();
    $roles = ( array ) $user->roles;
	if($roles[0]=='subscriber')
		$subject=str_replace('Nuevo pedido','Nuevo pedido PROFESIONAL',$subject);
	else
		$subject=str_replace('Nuevo pedido','Nuevo pedido PARTICULAR',$subject);
	//fernando@zakcosmetics.com, moyra@zakcosmetics.com
	return $subject;
}

function mytheme_add_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'mytheme_add_woocommerce_support' );

function parseTotal($total){
	$t=str_replace(',', '.', strip_tags(explode('<span class="woocommerce-Price-currencySymbol">', $total)[0]));
	$bi=number_format((float)round($t/1.21,2), 2, '.', ''); 
	$iva=number_format((float)round($t-$bi,2), 2, '.', ''); 
	$res['total']=str_replace('.',',',$t).'€';
	$res['bi']=str_replace('.',',',$bi).'€';
	$res['iva']=str_replace('.',',',$iva).'€';	
	return $res;
}
function swwp_change_coupon_preview( $label, $coupon ) {

	// WC 3.0+ compatibility
	if ( is_callable( array( $coupon, 'get_description' ) ) ) {
		$description = $coupon->get_description();
	} else {
		$coupon_post = get_post( $coupon->id );
		$description = ! empty( $coupon_post->post_excerpt ) ? $coupon_post->post_excerpt : null;
	}

	return $description ? sprintf( esc_html__( 'Coupon: %s', 'woocommerce' ), $description ) : esc_html__( 'Coupon', 'woocommerce' );
}
add_filter( 'woocommerce_cart_totals_coupon_label', 'swwp_change_coupon_preview', 10, 2 );

if ( !function_exists('wp_new_user_notification_email') ) {
   function wp_new_user_notification_email( ) {}
}
remove_action( 'register_new_user', 'wp_new_user_notification_email' );

add_action('phpmailer_init', 'wse199274_intercept_registration_email');
function wse199274_intercept_registration_email($phpmailer){
    $admin_email = get_option( 'admin_email' );

    # Intercept username and password email by checking subject line
    if( strpos($phpmailer->Subject, 'Your username and password info') ){
        # clear the recipient list
        $phpmailer->ClearAllRecipients();
        # optionally, send the email to the WordPress admin email
        //$phpmailer->AddAddress($admin_email);
    }else{
        #not intercepted
    }
}